/* PrinterException.java -- Generic problem in the printing subsystem.
   Copyright (C) 1999 Free Software Foundation, Inc.

This file is part of the non-peer AWT libraries of GNU Classpath.

This library is free software; you can redistribute it and/or modify
it under the terms of the GNU Library General Public License as published 
by the Free Software Foundation, either version 2 of the License, or
(at your option) any later verion.

This library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Library General Public License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; if not, write to the Free Software Foundation
Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307 USA. */


package java.awt.print;

import java.io.Serializable;

/**
  * This is the generic toplevel exception for printing errors.  Subclasses
  * provide more detailed descriptions of the problem.
  *
  * @author Aaron M. Renn (arenn@urbanophile.com)
  */
public class PrinterException extends Exception implements Serializable
{

/*
 * Constructors
 */

/**
  * Initializes a new instance of <code>PrinterException</code> with no
  * detailed error message.
  */
public
PrinterException()
{
  super();
}

/*************************************************************************/

/**
  * Initializes a new instance of <code>PrinterException</code> with a
  * descriptive error message.
  *
  * @param message The descriptive error message.
  */
public
PrinterException(String message)
{
  super(message);
}

} // class PrinterException

