/*
 * Decompiled with CFR 0.152.
 */
package servlet;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xpath.objects.XString;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.SAXException;
import servlet.ApplyXSLTException;
import servlet.ApplyXSLTListener;
import servlet.ApplyXSLTProperties;
import servlet.DefaultApplyXSLTProperties;
import servlet.OrderedProps;
import servlet.PIA;

public class ApplyXSLT
extends HttpServlet {
    protected ApplyXSLTProperties ourDefaultParameters = null;
    public static final String EOL = System.getProperty("line.separator");
    public static final String FS = System.getProperty("file.separator");
    public static final String ROOT = System.getProperty("server.root");
    public static String CURRENTDIR;
    protected OrderedProps ourMediaProps = null;
    protected static final String STYLESHEET_ATTRIBUTE = "media";
    protected static final String HEADER_NAME = "user-Agent";

    protected void displayException(HttpServletResponse httpServletResponse, ApplyXSLTException applyXSLTException, boolean bl) {
        String string = applyXSLTException.getMessage();
        string = string == null ? "" : "<B>" + string + "</B>";
        StringTokenizer stringTokenizer = new StringTokenizer(string, EOL);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(String.valueOf(stringTokenizer.nextToken()) + EOL + "<BR>");
        }
        string = stringBuffer.toString();
        if (bl) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream, true);
            applyXSLTException.getException().printStackTrace(printWriter);
            string = String.valueOf(string) + " <PRE> " + byteArrayOutputStream.toString() + " </PRE> ";
        }
        httpServletResponse.setContentType("text/html");
        try {
            httpServletResponse.sendError(applyXSLTException.getStatusCode(), string);
        }
        catch (IOException iOException) {
            System.err.println("IOException is occurring when sendError is called");
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            this.process(transformerFactory, httpServletRequest, httpServletResponse);
        }
        catch (Exception exception) {}
    }

    public String getContentType(Templates templates) {
        Properties properties = templates.getOutputProperties();
        String string = properties.getProperty("encoding");
        String string2 = properties.getProperty("media-type");
        if (string2 != null) {
            if (string != null) {
                return String.valueOf(string2) + "; charset=" + string;
            }
            return string2;
        }
        String string3 = properties.getProperty("method");
        if (string3.equals("html")) {
            return "text/html";
        }
        if (string3.equals("text")) {
            return "text/plain";
        }
        return "text/xml";
    }

    protected StreamSource getDocument(HttpServletRequest httpServletRequest, ApplyXSLTListener applyXSLTListener) throws ApplyXSLTException {
        try {
            String string = null;
            string = httpServletRequest.getPathInfo();
            if (string != null) {
                applyXSLTListener.out.println("Parsing XML Document from PathInfo: " + string);
                return new StreamSource(new URL("http", ((DefaultApplyXSLTProperties)this.ourDefaultParameters).getLocalHost(), string.replace('\\', '/')).openStream());
            }
            string = this.ourDefaultParameters.getXMLurl(httpServletRequest);
            if (string != null) {
                applyXSLTListener.out.println("Parsing XML Document from request parameter: " + string);
                return new StreamSource(new URL(string).openStream());
            }
            String string2 = httpServletRequest.getContentType();
            if (string2 != null && string2.startsWith("text/xml")) {
                applyXSLTListener.out.println("Parsing XML Document from request chain");
                return new StreamSource((InputStream)httpServletRequest.getInputStream());
            }
        }
        catch (IOException iOException) {
            throw new ApplyXSLTException(iOException, 404);
        }
        catch (Exception exception) {
            throw new ApplyXSLTException(exception, 500);
        }
        return null;
    }

    public String getMedia(HttpServletRequest httpServletRequest) {
        return this.ourMediaProps.getValue(httpServletRequest.getHeader(HEADER_NAME));
    }

    protected StreamSource getStylesheet(TransformerFactory transformerFactory, HttpServletRequest httpServletRequest, StreamSource streamSource, ApplyXSLTListener applyXSLTListener) throws ApplyXSLTException {
        try {
            String string = ((DefaultApplyXSLTProperties)this.ourDefaultParameters).getXSLRequestURL(httpServletRequest);
            if (string != null) {
                applyXSLTListener.out.println("Parsing XSL Stylesheet Document from request parameter: " + string);
            } else {
                if (streamSource != null) {
                    applyXSLTListener.out.println("calling getXSLURLfromDoc and getMedia " + this.getMedia(httpServletRequest));
                    string = ApplyXSLT.getXSLURLfromDoc(streamSource, STYLESHEET_ATTRIBUTE, this.getMedia(httpServletRequest), transformerFactory);
                }
                if (string != null) {
                    applyXSLTListener.out.println("Parsing XSL Stylesheet Document from XML Document tag: " + string);
                } else {
                    string = this.ourDefaultParameters.getXSLurl(null);
                    if (string != null) {
                        applyXSLTListener.out.println("Parsing XSL Stylesheet Document from configuration: " + string);
                    }
                }
            }
            return new StreamSource(string);
        }
        catch (IOException iOException) {
            throw new ApplyXSLTException(iOException, 404);
        }
        catch (Exception exception) {
            throw new ApplyXSLTException(exception, 500);
        }
    }

    public static String getXSLURLfromDoc(StreamSource streamSource, String string, String string2, TransformerFactory transformerFactory) {
        String string3 = null;
        String string4 = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(streamSource.getInputStream());
            Node node = document.getFirstChild();
            while (node != null) {
                PIA pIA;
                ProcessingInstruction processingInstruction;
                if (node.getNodeType() == 7 && (processingInstruction = (ProcessingInstruction)node).getNodeName().equals("xml-stylesheet") && "text/xsl".equals((pIA = new PIA(processingInstruction)).getAttribute("type"))) {
                    string3 = pIA.getAttribute("href");
                    String string5 = pIA.getAttribute(string);
                    if (string5 != null && string5.indexOf(string2) > -1) {
                        return string3;
                    }
                    if (!"yes".equals(pIA.getAttribute("alternate"))) {
                        string4 = string3;
                    }
                }
                node = node.getNextSibling();
            }
        }
        catch (Exception exception) {}
        return string4;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        CURRENTDIR = ROOT != null ? String.valueOf(ROOT) + FS + "servlets" + FS : String.valueOf(System.getProperty("user.dir")) + FS;
        this.setDefaultParameters(servletConfig);
        this.setMediaProps(servletConfig.getInitParameter("mediaURL"));
    }

    public void process(TransformerFactory transformerFactory, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException, SAXException {
        boolean bl = this.ourDefaultParameters.isDebug(httpServletRequest);
        long l = 0L;
        if (bl) {
            l = System.currentTimeMillis();
        }
        ApplyXSLTListener applyXSLTListener = new ApplyXSLTListener();
        applyXSLTListener.out.println("debug is " + bl);
        StreamSource streamSource = null;
        StreamSource streamSource2 = null;
        try {
            streamSource = this.getDocument(httpServletRequest, applyXSLTListener);
            if (streamSource == null) {
                throw new ApplyXSLTException("getDocument() returned null", new NullPointerException(), 404);
            }
        }
        catch (ApplyXSLTException applyXSLTException) {
            applyXSLTException.appendMessage(String.valueOf(EOL) + "getDocument() resulted in ApplyXSLTException" + EOL + applyXSLTListener.getMessage());
            if (bl) {
                this.writeLog(applyXSLTException);
            }
            this.displayException(httpServletResponse, applyXSLTException, bl);
            streamSource = null;
        }
        if (streamSource != null) {
            try {
                streamSource2 = this.getStylesheet(transformerFactory, httpServletRequest, streamSource, applyXSLTListener);
                if (streamSource2 == null) {
                    throw new ApplyXSLTException("getStylesheet() returned null", new NullPointerException(), 404);
                }
                streamSource = this.getDocument(httpServletRequest, applyXSLTListener);
            }
            catch (ApplyXSLTException applyXSLTException) {
                applyXSLTException.appendMessage(String.valueOf(EOL) + "getStylesheet() resulted in ApplyXSLTException" + EOL + applyXSLTListener.getMessage());
                if (bl) {
                    this.writeLog(applyXSLTException);
                }
                this.displayException(httpServletResponse, applyXSLTException, bl);
                streamSource2 = null;
            }
            if (streamSource != null && streamSource2 != null) {
                try {
                    applyXSLTListener.out.println("Performing transformation...");
                    Templates templates = transformerFactory.newTemplates(streamSource2);
                    Transformer transformer = templates.newTransformer();
                    try {
                        String string = null;
                        string = this.getContentType(templates);
                        httpServletResponse.setContentType(string);
                        if (transformer instanceof TransformerImpl) {
                            TransformerImpl transformerImpl = (TransformerImpl)transformer;
                            transformerImpl.setQuietConflictWarnings(this.ourDefaultParameters.isNoCW(httpServletRequest));
                        }
                        this.setStylesheetParams(transformer, httpServletRequest);
                        transformer.transform(streamSource, new StreamResult((OutputStream)httpServletResponse.getOutputStream()));
                        if (bl) {
                            this.writeLog(applyXSLTListener.getMessage(), 200);
                        }
                    }
                    catch (Exception exception) {
                        ApplyXSLTException applyXSLTException = new ApplyXSLTException("Exception occurred during Transformation:" + EOL + applyXSLTListener.getMessage() + EOL + exception.getMessage(), exception, 500);
                        if (bl) {
                            this.writeLog(applyXSLTException);
                        }
                        this.displayException(httpServletResponse, applyXSLTException, bl);
                    }
                }
                catch (Exception exception) {
                    ApplyXSLTException applyXSLTException = new ApplyXSLTException("Exception occurred during ctor/Transformation:" + EOL + applyXSLTListener.getMessage() + EOL + exception.getMessage(), exception, 500);
                    if (bl) {
                        this.writeLog(applyXSLTException);
                    }
                    this.displayException(httpServletResponse, applyXSLTException, bl);
                }
            }
            if (bl) {
                l = System.currentTimeMillis() - l;
                this.writeLog("  No Conflict Warnings = " + this.ourDefaultParameters.isNoCW(httpServletRequest) + "  Transformation time: " + l + " ms", 200);
            }
        }
    }

    protected void setDefaultParameters(ServletConfig servletConfig) {
        this.ourDefaultParameters = new DefaultApplyXSLTProperties(servletConfig);
    }

    protected void setMediaProps(String string) {
        block9: {
            block8: {
                if (string == null) break block8;
                URL uRL = null;
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    try {
                        uRL = new URL("file", "", String.valueOf(CURRENTDIR) + string);
                    }
                    catch (MalformedURLException malformedURLException2) {
                        this.writeLog("Unable to find the media properties file based on parameter 'mediaURL' = " + string, 202, malformedURLException2);
                        uRL = null;
                    }
                }
                if (uRL == null) break block9;
                try {
                    this.ourMediaProps = new OrderedProps(uRL.openStream());
                }
                catch (IOException iOException) {
                    this.writeLog("Exception occurred while opening media properties file: " + string + ".  Media table may be invalid.", 202, iOException);
                }
                break block9;
            }
            String string2 = String.valueOf(CURRENTDIR) + "media.properties";
            try {
                this.ourMediaProps = new OrderedProps(new FileInputStream(string2));
            }
            catch (IOException iOException) {
                this.writeLog("Default media properties file " + string2 + " not found.", 202, iOException);
            }
        }
    }

    public void setStylesheetParams(Transformer transformer, HttpServletRequest httpServletRequest) {
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            try {
                String[] stringArray = httpServletRequest.getParameterValues(string);
                if (stringArray == null) continue;
                transformer.setParameter(string, new XString(stringArray[0]));
            }
            catch (Exception exception) {}
        }
        try {
            transformer.setParameter("servlet-RemoteAddr", new XString(httpServletRequest.getRemoteAddr()));
        }
        catch (Exception exception) {}
        try {
            transformer.setParameter("servlet-RemoteHost", new XString(httpServletRequest.getRemoteHost()));
        }
        catch (Exception exception) {}
        try {
            transformer.setParameter("servlet-RemoteUser", new XString(httpServletRequest.getRemoteUser()));
        }
        catch (Exception exception) {}
    }

    protected URLConnection toAcceptLanguageConnection(URL uRL, HttpServletRequest httpServletRequest) throws Exception {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setRequestProperty("Accept-Language", httpServletRequest.getHeader("Accept-Language"));
        return uRLConnection;
    }

    protected void writeLog(String string, int n) {
        this.log("HTTP Status Code: " + n + " - " + string);
    }

    protected void writeLog(String string, int n, Throwable throwable) {
        if (throwable == null) {
            this.writeLog(string, n);
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream, true);
            System.out.println("Exception is " + throwable.getClass().getName());
            throwable.printStackTrace(printWriter);
            this.log("HTTP Status Code: " + n + " - " + string + EOL + byteArrayOutputStream.toString());
        }
    }

    protected void writeLog(ApplyXSLTException applyXSLTException) {
        this.writeLog(applyXSLTException.getMessage(), applyXSLTException.getStatusCode(), applyXSLTException.getException());
    }
}

