/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.rte.comm;

/**
 * a request packet as returned by the SocketCommunication to clients.
 *
 * This packet combines the RTE header with the client data. Returned
 * is a "pointer" to the start of the client data. This allows
 * SocketCommunication to easily get a pointer to the RTE header.
 */
public class RteSocketPacket extends com.sap.dbtech.util.StructuredBytes {
    com.sap.dbtech.util.StructuredBytes rteHeader;
    /**
     * create a new packet with logical size <i>size</i>.
     * @param size int
     */
    public RteSocketPacket(int size) {
        super(size + RteC.Header_END_O_C);
        this.rteHeader = (com.sap.dbtech.util.StructuredBytes) this.getPointer (0);
        this.moveBase (RteC.Header_END_O_C);
    }
}
