/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbc.exceptions;

import com.sap.dbtech.util.MessageKey;
import com.sap.dbtech.util.MessageTranslator;

/**
 *
 */
public class DatabaseException extends SQLExceptionSapDB {
    /**
     * DatabaseException constructor comment.
     * @param reason java.lang.String
     * @param sQLState java.lang.String
     * @param vendorCode int
     * @param errpos int
     */
    public DatabaseException(
        String reason,
        String sqlState,
        int vendorCode,
        int errpos)
    {
        super((errpos > 1) 
              ? MessageTranslator.translate(MessageKey.ERROR_DATABASEEXCEPTION, 
                    Integer.toString(vendorCode), Integer.toString(errpos), reason)
              : MessageTranslator.translate(MessageKey.ERROR_DATABASEEXCEPTION_WOERRPOS,
                    Integer.toString(vendorCode), reason),
              sqlState, vendorCode, errpos);
         
    }

}
