/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.remoting.transport.multiplex;

import java.net.InetAddress;
import java.net.Socket;
import java.util.HashMap;

import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;

import junit.framework.TestCase;

/**
 * This class tests what happens when a 
 * <p>
 * <ol>
 *  <li>a <code>Connector</code> starts;
 *  <li>a <code>Client</code> connects to the <code>Connector</code>;
 *  <li>the <code>Connector</code> stops; and 
 *  <li>then the <code>Client</code> disconnects.
 * </ol>
 * <p>
 * The <code>Client</code> should be able to disconnect gracefully, without exceptions.
 * <p>
 * @author <a href="mailto:ron.sigal@jboss.com">Ron Sigal</a>
 * <p>
 * Copyright (c) Jul 20, 2006
 * </p>
 */
public class LateClientShutdownTestClient extends TestCase
{
   public void testShutdown()
   {
      HashMap conf = new HashMap();
      conf.put(InvokerLocator.FORCE_REMOTE, "true");
      try
      {
         Client client = new Client(new InvokerLocator(LateClientShutdownTestServer.serverLocatorURI), conf);
         Socket s = null;
         
         for (int i = 0; i < 5; i++)
         {
            try
            {
               s = new Socket(InetAddress.getLocalHost(), LateClientShutdownTestServer.syncSocketPort);
               if (s != null)
                  break;
               Thread.sleep(1000);
            }
            catch (Exception e)
            {
               Thread.sleep(1000);
            }
         }
         
         if (s == null)
            throw new Exception("cannot connect to server");
         
         s.close();
         System.out.println("connecting client");
         client.connect();
         System.out.println("client connected");
         Thread.sleep(5000);
         System.out.println("client disconnecting");
         client.disconnect();
         System.out.println("client disconnected");
      }
      catch (Exception e)
      {
         e.printStackTrace();
         fail();
      }
   }
}
