/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

package org.jboss.test.remoting.transport.multiplex;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Date;
import java.util.Random;
import org.apache.log4j.Category;
import org.apache.log4j.FileAppender;
import org.apache.log4j.PatternLayout;
import org.jboss.logging.Logger;
import org.jboss.remoting.transport.multiplex.VirtualSocket;

import junit.framework.TestCase;


/**
 * A BasicBehaviorClient.
 *
 * @author <a href="mailto:r.sigal@computer.org">Ron Sigal</a>
 * @version $Revision: 995 $
 *          <p/>
 *          Copyright (c) 2005
 *          </p>
 */

public class BasicBehaviorClient extends TestCase implements MultiplexConstants
{
   protected static final Logger log = Logger.getLogger(BasicBehaviorClient.class);
   protected static int nextBindPort = clientServerSocketPort;
   protected static int nextConnectPort = masterServerSocketPort - 1;
   protected static Socket scriptSocket;
   protected static Random random;
   protected static OutputStream scriptStream;
   protected String testName;
   protected Socket testSocket;
   protected InputStream is;
   protected OutputStream os;
   protected boolean basicBehaviorStarted = false;
   protected boolean testsOver = false;


   public void setUp() throws Exception
   {
      testName = getName();
      log.info("entering setUp() for test: " + testName);
      Exception savedException = null;

      if(scriptSocket == null)
      {
         scriptSocket = new VirtualSocket();
         InetSocketAddress address = new InetSocketAddress(basicBehaviorServerHost, basicBehaviorServerPort);

         for(int i = 0; i < 5; i++)
         {
            try
            {
               scriptSocket.connect(address, 5000);
               break;
            }
            catch(IOException e)
            {
               log.info("unable to connect script socket: trying again");
               savedException = e;

               try
               {
                  Thread.sleep(1000);
               }
               catch(InterruptedException ignored)
               {
               }
            }
         }

         if(scriptSocket == null)
         {
            log.error(savedException);
            savedException.printStackTrace();
            throw savedException;
         }

         scriptStream = scriptSocket.getOutputStream();
         log.info("BasicBehaviorClient: got message socket and message OutputStream");

         String pattern = "%5p [%t] (%F:%L) <%d{ABSOLUTE}> - %m%n";
         PatternLayout layout = new PatternLayout(pattern);

         try
         {
            File logFile = new File("test_logs");
            logFile.mkdir();
            FileAppender fileAppender = new FileAppender(layout, "test_logs" + File.separator + "basic.output.log");
            fileAppender.setAppend(false);
            //fileAppender.setThreshold(Level.toLevel(testLogLevel));
            Category.getRoot().addAppender(fileAppender);
         }
         catch(IOException e)
         {
            e.printStackTrace();
         }
      }

      testSocket = new VirtualSocket(basicBehaviorServerHost, basicBehaviorServerPort);

      log.info("BasicBehaviorClient: got test socket: " + 
               ((VirtualSocket)testSocket).getLocalSocketId().getPort());

      if(random == null)
      {
         random = new Random(new Date().getTime());
      }

      log.info("leaving setUp() for test: " + testName);
   }

   public void tearDown() throws Exception
   {
      log.info("entering tearDown() for test: " + testName);
      testSocket.close();
      testSocket = null;

      if(testsOver)
      {
         scriptSocket.close();
      }

      log.info("leaving tearDown() for test: " + testName);
   }
}

