/*-- $Id: XSPClassLoader.java,v 1.5 2000/02/13 18:29:37 stefano Exp $ --

 ============================================================================
                   The Apache Software License, Version 1.1
 ============================================================================

 Copyright (C) 1999-2000 The Apache Software Foundation. All rights reserved.

 Redistribution and use in source and binary forms, with or without modifica-
 tion, are permitted provided that the following conditions are met:

 1. Redistributions of  source code must  retain the above copyright  notice,
    this list of conditions and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.

 3. The end-user documentation included with the redistribution, if any, must
    include  the following  acknowledgment:  "This product includes  software
    developed  by the  Apache Software Foundation  (http://www.apache.org/)."
    Alternately, this  acknowledgment may  appear in the software itself,  if
    and wherever such third-party acknowledgments normally appear.

 4. The names "Cocoon" and  "Apache Software Foundation"  must not be used to
    endorse  or promote  products derived  from this  software without  prior
    written permission. For written permission, please contact
    apache@apache.org.

 5. Products  derived from this software may not  be called "Apache", nor may
    "Apache" appear  in their name,  without prior written permission  of the
    Apache Software Foundation.

 THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 FITNESS  FOR A PARTICULAR  PURPOSE ARE  DISCLAIMED.  IN NO  EVENT SHALL  THE
 APACHE SOFTWARE  FOUNDATION  OR ITS CONTRIBUTORS  BE LIABLE FOR  ANY DIRECT,
 INDIRECT, INCIDENTAL, SPECIAL,  EXEMPLARY, OR CONSEQUENTIAL  DAMAGES (INCLU-
 DING, BUT NOT LIMITED TO, PROCUREMENT  OF SUBSTITUTE GOODS OR SERVICES; LOSS
 OF USE, DATA, OR  PROFITS; OR BUSINESS  INTERRUPTION)  HOWEVER CAUSED AND ON
 ANY  THEORY OF LIABILITY,  WHETHER  IN CONTRACT,  STRICT LIABILITY,  OR TORT
 (INCLUDING  NEGLIGENCE OR  OTHERWISE) ARISING IN  ANY WAY OUT OF THE  USE OF
 THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 This software  consists of voluntary contributions made  by many individuals
 on  behalf of the Apache Software  Foundation and was  originally created by
 Stefano Mazzocchi  <stefano@apache.org>. For more  information on the Apache
 Software Foundation, please see <http://www.apache.org/>.

 */

package org.apache.cocoon.processor.xsp.language.java;

import java.io.*;

/**
 * @author <a href="mailto:ricardo@apache.org">Ricardo Rocha</a>
 * @version $Revision: 1.5 $ $Date: 2000/02/13 18:29:37 $
 */
public class XSPClassLoader extends ClassLoader {
  protected File repository;

  public XSPClassLoader (File repository) {
    this.repository = repository;
  }

  public XSPClassLoader reinstantiate() {
    return new XSPClassLoader(this.repository);
  }

  protected Class loadClass (String name, boolean resolve)
    throws ClassNotFoundException
  {
    Class c = findLoadedClass(name);

    if (c == null) {
      try {
        c = findSystemClass(name);
      } catch (ClassNotFoundException e) {
        byte[] bits = loadClassData (name);

        if (bits == null) {
          // ClassLoader cl = getParent();
          ClassLoader cl = this.getClass().getClassLoader();

          if (cl != null)  {
            c = cl.loadClass (name);
          }
        } else {
          c = defineClass (null, bits, 0, bits.length);

          if (resolve) {
            resolveClass (c);
          }
        }
      }

      if (c == null) {
        throw new ClassNotFoundException (name);
      }
    }

    return c;
  }

  protected byte[] loadClassData (String className) {
    File file = new File(this.getClassFileName(className));

    byte[] buf = null;
    FileInputStream in = null;

    int n = 0;
    int pos = 0;

    if (file.exists ()) {
      buf = new byte [(int) file.length ()];

      try {
        in = new FileInputStream (file);

        while (
          pos < buf.length &&
          (n = in.read (buf, pos, buf.length - pos)) != -1
        ) {
          pos += n;
        }
      } catch (IOException e) {
        buf = null;
      } finally {
        if (in != null) {
          try { in.close(); }
          catch (IOException e) { }
        }
      }
    }

    return buf;
  }

  protected String getClassFileName(String className) {
    try {
      return
        this.repository.getCanonicalPath() + File.separator +
        className.replace('.', File.separatorChar) + ".class";
    } catch (IOException e) {
      return null;
    }
  }
}
