/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Zip;

public class Jar
extends Zip {
    private File manifest;

    protected void initZipOutputStream(ZipOutputStream zOut) throws IOException, BuildException {
        if (this.manifest != null) {
            super.zipDir(new File(this.manifest.getParent()), zOut, "META-INF/");
            super.zipFile(this.manifest, zOut, "META-INF/MANIFEST.MF");
        } else {
            String s = "/org/apache/tools/ant/defaultManifest.mf";
            InputStream in = this.getClass().getResourceAsStream(s);
            if (in == null) {
                throw new BuildException("Could not find: " + s);
            }
            this.zipFile(in, zOut, "META-INF/MANIFEST.MF", System.currentTimeMillis());
        }
    }

    public void setJarfile(String jarFilename) {
        super.setZipfile(jarFilename);
        this.archiveType = "jar";
    }

    public void setManifest(String manifestFilename) {
        this.manifest = this.project.resolveFile(manifestFilename);
    }

    protected void zipDir(File dir, ZipOutputStream zOut, String vPath) throws IOException {
        if (!vPath.equals("META-INF/")) {
            super.zipDir(dir, zOut, vPath);
        }
    }

    protected void zipFile(File file, ZipOutputStream zOut, String vPath) throws IOException {
        if (!vPath.equals("META-INF/MANIFEST.MF")) {
            super.zipFile(file, zOut, vPath);
        }
    }
}

