
/* spoonman@unforgettable.com */

#include <sys/param.h>
#include <gnome.h>
#include <applet-widget.h>
#include <signal.h>
#include "config.h"
#include "plaid.xpm"
#include "gnote.h"

  /* our applet */
  static GtkWidget *applet;

  /* what happens when a button is pressed */
  static gint applet_button_press_cb(GtkWidget *widget, GdkEventButton *event,
    gpointer data)
    {
    g_debug("applet_button_press_cb();");

    switch(event->button)
      {
      case 1:
        gnote_new_cb(APPLET_WIDGET(applet), GNOTE_NEW_1x1);
        break;
      default:
        return(FALSE);
      };
    return(TRUE);
    };


  /* create the plaid button */
  static GtkWidget *create_plaid_button(GtkWidget *window)
    {
    GtkWidget *nbutton, *pixmap;

    nbutton = gtk_button_new();
    pixmap = gnome_pixmap_new_from_xpm_d((gchar **)plaid_xpm);
    gtk_container_add(GTK_CONTAINER(nbutton), pixmap);
    gtk_signal_connect(GTK_OBJECT(nbutton), "button_press_event",
      GTK_SIGNAL_FUNC(applet_button_press_cb), NULL);

    return(nbutton); 
    };


  /* sesion save signal handler*/
  static gint applet_session_save(AppletWidget *applet, char *cfgpath,
    char *globcfgpath)
    {
    g_debug("applet_session_save();");
 
    gnotes_action(applet, GNOTES_SAVE);
 
/* 
    gnome_config_push_prefix(privcfgpath);
    gnome_config_set_string("section/gnotes", hello);
    gnome_config_pop_prefix(privcfgpath);
*/
  
    gnome_config_sync();
    gnome_config_drop_all();
  
  
    /* make sure you return FALSE, otherwise your applet might not
       work compeltely, there are very few circumstances where you
       want to return TRUE. This behaves similiar to GTK events, in
       that if you return FALSE it means that you haven't done
       everything yourself, meaning you want the panel to save your
       other state such as the panel you are on, position,
       parameter, etc ... */
  
    return(FALSE);
    };
  

  /* the about box */
  void about_cb(AppletWidget *applet, gpointer data)
    {
    GtkWidget *about;
    const gchar *authors[] = {"spoonman <spoonman@unforgettable.com>", NULL};
 
    about = gnome_about_new (_("GNotes Applet"), "v"VERSION,
                    _("(C) 1998 spoonman <spoonman@unforgettable.com>"),
                    authors,
                    "Allows you to put cool little yellow sticky notes "
                      "all over your screen.",
                    NULL);
    gtk_widget_show(about);
    };


  /* the properties box */
  static void properties_cb(AppletWidget *applet, gpointer data)
    {
    GtkWidget *pb;
    GtkWidget *vbox;
  /*
    GtkWidget *entry;
  */
    GtkWidget *label;
  
    g_debug("properties_cb();");
  
    pb = gnome_property_box_new();
    gtk_window_set_title(GTK_WINDOW(pb), _("GNotes Properties"));
  
    vbox = gtk_vbox_new(GNOME_PAD, FALSE);
    gtk_container_border_width(GTK_CONTAINER(vbox), GNOME_PAD);
  
  /*
    label = gtk_label_new(_("Your GNOME Fish's Name:"));
    entry = gtk_entry_new();
  
    gtk_entry_set_text(GTK_ENTRY(entry), properties.name);
  
    gtk_signal_connect_object(GTK_OBJECT(entry), "changed",
                              GTK_SIGNAL_FUNC(gnome_property_box_changed),
                              GTK_OBJECT(pb));
  
  */
    gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, GNOME_PAD);
  /*
    gtk_box_pack_start(GTK_BOX(vbox), entry, TRUE, TRUE, GNOME_PAD);
    gnome_property_box_append_page(GNOME_PROPERTY_BOX(pb), vbox,
                                   gtk_label_new(_("Name")));
  
    gtk_signal_connect(GTK_OBJECT(pb), "apply", GTK_SIGNAL_FUNC(apply_cb),
                       entry);
  */
  
    gtk_widget_show_all(pb);
    };


  /* create main menu */
  void create_mainmenu(GtkWidget *applet)
    {
    /* add an item to the applet menu */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "about",
       GNOME_STOCK_MENU_ABOUT, _("About..."), about_cb, NULL);
/*
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "properties",
      GNOME_STOCK_PIXMAP_PROPERTIES, _("Properties..."), properties_cb, NULL);
*/
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), GNOTE_NEW_4x5,
      GNOME_STOCK_PIXMAP_NEW, _(GNOTE_NEW_4x5), gnote_new_cb, GNOTE_NEW_4x5);
    applet_widget_register_callback(APPLET_WIDGET(applet), GNOTE_NEW_4x4,
      _(GNOTE_NEW_4x4), gnote_new_cb, GNOTE_NEW_4x4);
    applet_widget_register_callback(APPLET_WIDGET(applet), GNOTE_NEW_3x4,
      _(GNOTE_NEW_3x4), gnote_new_cb, GNOTE_NEW_3x4);
    applet_widget_register_callback(APPLET_WIDGET(applet), GNOTE_NEW_3x3,
      _(GNOTE_NEW_3x3), gnote_new_cb, GNOTE_NEW_3x3);
    applet_widget_register_callback(APPLET_WIDGET(applet), GNOTE_NEW_2x3,
      _(GNOTE_NEW_2x3), gnote_new_cb, GNOTE_NEW_2x3);
    applet_widget_register_callback(APPLET_WIDGET(applet), GNOTE_NEW_2x2,
      _(GNOTE_NEW_2x2), gnote_new_cb, GNOTE_NEW_2x2);
    applet_widget_register_callback(APPLET_WIDGET(applet), GNOTE_NEW_1x2,
      _(GNOTE_NEW_1x2), gnote_new_cb, GNOTE_NEW_1x2);
    applet_widget_register_callback(APPLET_WIDGET(applet), GNOTE_NEW_1x1,
      _(GNOTE_NEW_1x1), gnote_new_cb, GNOTE_NEW_1x1);
    applet_widget_register_callback(APPLET_WIDGET(applet), GNOTES_RAISE,
      _(GNOTES_RAISE), gnotes_action, GNOTES_RAISE);
    applet_widget_register_callback(APPLET_WIDGET(applet), GNOTES_LOWER,
      _(GNOTES_LOWER), gnotes_action, GNOTES_LOWER);
    applet_widget_register_callback(APPLET_WIDGET(applet), GNOTES_HIDE,
      _(GNOTES_HIDE), gnotes_action, GNOTES_HIDE);
    applet_widget_register_callback(APPLET_WIDGET(applet), GNOTES_SHOW,
      _(GNOTES_SHOW), gnotes_action, GNOTES_SHOW);
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), GNOTES_SAVE,
      GNOME_STOCK_PIXMAP_SAVE, _(GNOTES_SAVE), gnotes_action, GNOTES_SAVE);

#ifdef TEST
    /* an open folder */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "open",
      GNOME_STOCK_PIXMAP_OPEN, _("open"), gnote_new_cb, GNOTE_NEW_4x4);
    /* a little black X */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "close",
      GNOME_STOCK_PIXMAP_CLOSE, _("close"), gnote_new_cb, GNOTE_NEW_4x4);
    /* a floppy with an arrow pointing out */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "revert",
      GNOME_STOCK_PIXMAP_REVERT, _("revert"), gnote_new_cb, GNOTE_NEW_4x4);
    /* a floppy */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "save",
      GNOME_STOCK_PIXMAP_SAVE, _("save"), gnote_new_cb, GNOTE_NEW_4x4);
    /* a floppy with a pencil writing on it */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "save_as",
      GNOME_STOCK_PIXMAP_SAVE_AS, _("save_as"), gnote_new_cb, GNOTE_NEW_4x4);
    /* scissors */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "cut",
      GNOME_STOCK_PIXMAP_CUT, _("cut"), gnote_new_cb, GNOTE_NEW_4x4);
    /* paper to paper */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "copy",
      GNOME_STOCK_PIXMAP_COPY, _("copy"), gnote_new_cb, GNOTE_NEW_4x4);
    /* clipboard to paper */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "paste",
      GNOME_STOCK_PIXMAP_PASTE, _("paste"), gnote_new_cb, GNOTE_NEW_4x4);
    /* paper with pencil writing on it */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "properties",
      GNOME_STOCK_PIXMAP_PROPERTIES, _("properties"), gnote_new_cb, GNOTE_NEW_4x4);
    /* paper with pencil writing on it */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "preferences",
      GNOME_STOCK_PIXMAP_PREFERENCES, _("preferences"), gnote_new_cb, GNOTE_NEW_4x4);
    /* question mark */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "help",
      GNOME_STOCK_PIXMAP_HELP, _("help"), gnote_new_cb, GNOTE_NEW_4x4);
    /* olympic type podium 3 1 2*/
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "scores",
      GNOME_STOCK_PIXMAP_SCORES, _("scores"), gnote_new_cb, GNOTE_NEW_4x4);
    /* printer */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "print",
      GNOME_STOCK_PIXMAP_PRINT, _("print"), gnote_new_cb, GNOTE_NEW_4x4);
    /* paper with magnifying glass */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "search",
      GNOME_STOCK_PIXMAP_SEARCH, _("search"), gnote_new_cb, GNOTE_NEW_4x4);
    /* paper with magnifying glass and pencil writing */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "srchrpl",
      GNOME_STOCK_PIXMAP_SRCHRPL, _("srchrpl"), gnote_new_cb, GNOTE_NEW_4x4);
    /* arrow left */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "back",
      GNOME_STOCK_PIXMAP_BACK, _("back"), gnote_new_cb, GNOTE_NEW_4x4);
    /* arrow right */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "forward",
      GNOME_STOCK_PIXMAP_FORWARD, _("forward"), gnote_new_cb, GNOTE_NEW_4x4);
    /* arrow left with a stop */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "first",
      GNOME_STOCK_PIXMAP_FIRST, _("first"), gnote_new_cb, GNOTE_NEW_4x4);
    /* arrow right with a stop */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "last",
      GNOME_STOCK_PIXMAP_LAST, _("last"), gnote_new_cb, GNOTE_NEW_4x4);
    /* a home */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "home",
      GNOME_STOCK_PIXMAP_HOME, _("home"), gnote_new_cb, GNOTE_NEW_4x4);
    /* red circle with black x */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "stop",
      GNOME_STOCK_PIXMAP_STOP, _("stop"), gnote_new_cb, GNOTE_NEW_4x4);
    /* two arrows in a circle */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "refresh",
      GNOME_STOCK_PIXMAP_REFRESH, _("refresh"), gnote_new_cb, GNOTE_NEW_4x4);
    /* arrow up & left */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "undo",
      GNOME_STOCK_PIXMAP_UNDO, _("undo"), gnote_new_cb, GNOTE_NEW_4x4);
    /* arrow up & right */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "redo",
      GNOME_STOCK_PIXMAP_REDO, _("redo"), gnote_new_cb, GNOTE_NEW_4x4);
    /* clock arrow right */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "timer",
      GNOME_STOCK_PIXMAP_TIMER, _("timer"), gnote_new_cb, GNOTE_NEW_4x4);
    /* clock red X */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "timer_stop",
      GNOME_STOCK_PIXMAP_TIMER_STOP, _("timer_stop"), gnote_new_cb, GNOTE_NEW_4x4);
    /* envelope */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "mail",
      GNOME_STOCK_PIXMAP_MAIL, _("mail"), gnote_new_cb, GNOTE_NEW_4x4);
    /* envelope arrow down */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "mail_rcv",
      GNOME_STOCK_PIXMAP_MAIL_RCV, _("mail_rcv"), gnote_new_cb, GNOTE_NEW_4x4);
    /* envelope arrow up */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "mail_snd",
      GNOME_STOCK_PIXMAP_MAIL_SND, _("mail_snd"), gnote_new_cb, GNOTE_NEW_4x4);
    /* envelope arrow left */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "mail_rpl",
      GNOME_STOCK_PIXMAP_MAIL_RPL, _("mail_rpl"), gnote_new_cb, GNOTE_NEW_4x4);
    /* envelope arrow right */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "mail_fwd",
      GNOME_STOCK_PIXMAP_MAIL_FWD, _("mail_fwd"), gnote_new_cb, GNOTE_NEW_4x4);
    /* envelope pencil */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "mail_new",
      GNOME_STOCK_PIXMAP_MAIL_NEW, _("mail_new"), gnote_new_cb, GNOTE_NEW_4x4);
    /* trash can */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "trash",
      GNOME_STOCK_PIXMAP_TRASH, _("trash"), gnote_new_cb, GNOTE_NEW_4x4);
    /* trash can & bag */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "trash_full",
      GNOME_STOCK_PIXMAP_TRASH_FULL, _("trash_full"), gnote_new_cb, GNOTE_NEW_4x4);
    /* trash can arrow up */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "undelete",
      GNOME_STOCK_PIXMAP_UNDELETE, _("undelete"), gnote_new_cb, GNOTE_NEW_4x4);
    /* abc & check mark */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "spellcheck",
      GNOME_STOCK_PIXMAP_SPELLCHECK, _("spellcheck"), gnote_new_cb, GNOTE_NEW_4x4);
    /* microphone */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "mic",
      GNOME_STOCK_PIXMAP_MIC, _("mic"), gnote_new_cb, GNOTE_NEW_4x4);
    /* red/white stereo plug */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "line_in",
      GNOME_STOCK_PIXMAP_LINE_IN, _("line_in"), gnote_new_cb, GNOTE_NEW_4x4);
    /* speaker */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "volume",
      GNOME_STOCK_PIXMAP_VOLUME, _("volume"), gnote_new_cb, GNOTE_NEW_4x4);
    /* red book */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "book_red",
      GNOME_STOCK_PIXMAP_BOOK_RED, _("book_red"), gnote_new_cb, GNOTE_NEW_4x4);
    /* green book */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "book_green",
      GNOME_STOCK_PIXMAP_BOOK_GREEN, _("book_green"), gnote_new_cb, GNOTE_NEW_4x4);
    /* blue book */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "book_blue",
      GNOME_STOCK_PIXMAP_BOOK_BLUE, _("book_blue"), gnote_new_cb, GNOTE_NEW_4x4);
    /* yellow book */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "book_yellow",
      GNOME_STOCK_PIXMAP_BOOK_YELLOW, _("book_yellow"), gnote_new_cb, GNOTE_NEW_4x4);
    /* open book */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "book_open",
      GNOME_STOCK_PIXMAP_BOOK_OPEN, _("book_open"), gnote_new_cb, GNOTE_NEW_4x4);
    /* flower */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "about",
      GNOME_STOCK_PIXMAP_ABOUT, _("about"), gnote_new_cb, GNOTE_NEW_4x4);
    /* door with arrow */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "quit",
      GNOME_STOCK_PIXMAP_QUIT, _("quit"), gnote_new_cb, GNOTE_NEW_4x4);
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "multiple",
      GNOME_STOCK_PIXMAP_MULTIPLE, _("multiple"), gnote_new_cb, GNOTE_NEW_4x4);
    /* red circle with slash */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "not",
      GNOME_STOCK_PIXMAP_NOT, _("not"), gnote_new_cb, GNOTE_NEW_4x4);
    /* door with arrow */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "exit",
      GNOME_STOCK_PIXMAP_EXIT, _("exit"), gnote_new_cb, GNOTE_NEW_4x4);
    /* nothing */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "regular",
      GNOME_STOCK_PIXMAP_REGULAR, _("regular"), gnote_new_cb, GNOTE_NEW_4x4);
    /* nothing */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "disabled",
      GNOME_STOCK_PIXMAP_DISABLED, _("disabled"), gnote_new_cb, GNOTE_NEW_4x4);
    /* nothing */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet), "focused",
      GNOME_STOCK_PIXMAP_FOCUSED, _("focused"), gnote_new_cb, GNOTE_NEW_4x4);
#endif
    };

  static void gnotes_button(gboolean appletmode)
    {
    GtkWidget *plaid_button, *window, *handle_box, *hbox;

    if (appletmode)
      {
      g_debug("gnotes_button(APPLET);");
      }
    else
      {
      g_debug("gnotes_button(WINDOW);");
      g_warning("GNotes: Window mode not fully implemented");
      };

    if (!(applet=applet_widget_new()))
      {
      g_error("GNotes: main(): can't create applet");
      };

    /* session_save signal */
    gtk_signal_connect(GTK_OBJECT(applet),"save_session",
      GTK_SIGNAL_FUNC(applet_session_save), NULL);

    create_mainmenu(applet);

    plaid_button = create_plaid_button(applet);

    if (appletmode)
      {
      applet_widget_add(APPLET_WIDGET(applet), plaid_button);
      gtk_widget_show_all(applet);
      }
    else
      {
      /* create window */
      window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
      gtk_window_set_policy(GTK_WINDOW(window), TRUE, TRUE, TRUE);

      /* create handle_box */
      handle_box = gtk_handle_box_new();
      gtk_signal_connect(GTK_OBJECT(handle_box), "motion_notify_event",
        GTK_SIGNAL_FUNC(gnote_motion_cb), NULL);
      gtk_signal_connect(GTK_OBJECT(handle_box), "button_press_event",
        GTK_SIGNAL_FUNC(gnote_handle_button_cb), NULL);
      gtk_signal_connect(GTK_OBJECT(handle_box), "button_release_event",
        GTK_SIGNAL_FUNC(gnote_handle_button_cb), NULL);
      gtk_widget_set_usize(handle_box, 10, 0);

      /* create hbox */
      hbox = gtk_hbox_new(FALSE, 0);

      /* pack it up! */
      gtk_box_pack_start(GTK_BOX(hbox), handle_box, FALSE, FALSE, 0);
      gtk_box_pack_start(GTK_BOX(hbox), plaid_button, FALSE, FALSE, 0);
      gtk_container_add(GTK_CONTAINER(window), hbox);

      gtk_widget_show_all(window);

      gdk_window_set_decorations(window->window, 0);
      };

    /* let's load us some notes! */
    gnotes_action(NULL, GNOTES_LOAD);

    /* wait for a signal! */
    signal(SIGHUP, gnote_signal_handler);

    /* special corba main loop */
    applet_widget_gtk_main ();
    };


  /* These are the arguments that our application supports.  */
  static struct argp_option arguments[] =
    {
    /* damn it, the panel doesn't pass on command line arguments from
       the .desktop file to the ~/.gnome/panel.d/default/Applet_Config
       file.  I'd prefer to use "--applet" for gnotes.desktop and no
       command line argument for window mode... */
    {"window", -1, NULL, 0,
      N_("To use GNotes without the Gnome Panel"), 1},
    {NULL, 0, NULL, 0, NULL, 0}
    };

  /* Forward declaration of the function that gets called when one of
     our arguments is recognized.  */
  /* we ignore the arguments */
  static error_t parse_an_arg(int key, char *arg, struct argp_state *state)
    {
    return(0);
    };

  /* This structure defines our parser.  It can be used to specify some
     options for how our parsing function should be called.  */
  static struct argp parser =
    {
    arguments,                      /* Options.  */
    parse_an_arg,                   /* The parser function.  */
    NULL,                           /* Some docs.  */
    NULL,                           /* Some more docs.  */
    NULL,                           /* Child arguments -- gnome_init fills
                                       this in for us.  */
    NULL,                           /* Help filter.  */
    NULL                            /* Translation domain; for the app it
                                       can always be NULL.  */
    };

/* the main, duh */
int main(int argc, char **argv)
  {
  char dirname[MAXPATHLEN];
  gchar *param;

  sprintf(dirname,"%s/%s", getenv("HOME"), GNOTES_DIR);

  mkdir(dirname, 0700);
  chdir(dirname);

  /* Initialize the i18n stuff */
  bindtextdomain(PACKAGE, GNOMELOCALEDIR);
  textdomain(PACKAGE);

  /* we make a param string, instead of first parsing the params with argp, we
     will always use a string, since the panel will only give us a string */
  param = make_param_string(argc, argv);

  applet_widget_init_defaults("GNotes", &parser, argc, argv, 0, NULL, argv[0]);

  if (!strcmp(param, "--window"))
    {
    gnotes_button(FALSE);
    }
  else
    {
    gnotes_button(TRUE);
    };

  return(0);
  };

