/* Author:  G. Jungman
 * RCS:     gsl_sf_poly.h,v 1.1 1998/05/05 13:48:50 jungman Exp
 */
#ifndef GSL_SF_POLY_H_
#define GSL_SF_POLY_H_

/* c[0] + c[1] x + c[2] x^2 + ... + c[len-1] x^(len-1)
 */
extern inline double gsl_sf_poly_eval(const double c[], const int len, const double x)
{
  int i;
  double ans = c[len-1];
  for(i=len-1; i>0; i--) ans = c[i-1] + x * ans;
  return ans;
}


#endif  /* !GSL_SF_POLY_H_ */
