/*
 * Copyright (c) 1997,1998 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Mon Sep 28 17:18:42 EDT 1998 */

#include <fftw-int.h>
#include <fftw.h>

/* Generated by: ./genfft -magic-alignment-check -magic-twiddle-load-all -magic-variables 4 -magic-loopi -hc2hc-forward 4 */

/*
 * This function contains 38 FP additions, 18 FP multiplications,
 * (or, 32 additions, 12 multiplications, 6 fused multiply/add),
 * 19 stack variables, and 32 memory accesses
 */

/*
 * Generator Id's : 
 * $Id: exprdag.ml,v 1.35 1998/09/25 19:14:16 athena Exp $
 * $Id: fft.ml,v 1.40 1998/09/14 14:43:06 fftw Exp $
 * $Id: to_c.ml,v 1.23 1998/09/14 14:43:08 fftw Exp $
 */

void fftw_hc2hc_forward_4(fftw_real *A, const fftw_complex *W, int iostride, int m, int dist)
{
     int i;
     fftw_real *X;
     fftw_real *Y;
     X = A;
     Y = A + (4 * iostride);
     {
	  fftw_real tmp45;
	  fftw_real tmp46;
	  fftw_real tmp47;
	  fftw_real tmp48;
	  fftw_real tmp49;
	  fftw_real tmp50;
	  ASSERT_ALIGNED_DOUBLE();
	  tmp45 = X[0];
	  tmp46 = X[2 * iostride];
	  tmp47 = tmp45 + tmp46;
	  tmp48 = X[iostride];
	  tmp49 = X[3 * iostride];
	  tmp50 = tmp48 + tmp49;
	  X[iostride] = tmp45 - tmp46;
	  Y[-iostride] = -(tmp48 - tmp49);
	  X[2 * iostride] = tmp47 - tmp50;
	  X[0] = tmp47 + tmp50;
     }
     X = X + dist;
     Y = Y - dist;
     for (i = 2; i < m; i = i + 2, X = X + dist, Y = Y - dist, W = W + 3) {
	  fftw_real tmp17;
	  fftw_real tmp40;
	  fftw_real tmp22;
	  fftw_real tmp39;
	  fftw_real tmp28;
	  fftw_real tmp36;
	  fftw_real tmp33;
	  fftw_real tmp37;
	  ASSERT_ALIGNED_DOUBLE();
	  tmp17 = X[0];
	  tmp40 = Y[-3 * iostride];
	  {
	       fftw_real tmp19;
	       fftw_real tmp21;
	       fftw_real tmp18;
	       fftw_real tmp20;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp19 = X[2 * iostride];
	       tmp21 = Y[-iostride];
	       tmp18 = c_re(W[1]);
	       tmp20 = c_im(W[1]);
	       tmp22 = (tmp18 * tmp19) - (tmp20 * tmp21);
	       tmp39 = (tmp20 * tmp19) + (tmp18 * tmp21);
	  }
	  {
	       fftw_real tmp25;
	       fftw_real tmp27;
	       fftw_real tmp24;
	       fftw_real tmp26;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp25 = X[iostride];
	       tmp27 = Y[-2 * iostride];
	       tmp24 = c_re(W[0]);
	       tmp26 = c_im(W[0]);
	       tmp28 = (tmp24 * tmp25) - (tmp26 * tmp27);
	       tmp36 = (tmp26 * tmp25) + (tmp24 * tmp27);
	  }
	  {
	       fftw_real tmp30;
	       fftw_real tmp32;
	       fftw_real tmp29;
	       fftw_real tmp31;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp30 = X[3 * iostride];
	       tmp32 = Y[0];
	       tmp29 = c_re(W[2]);
	       tmp31 = c_im(W[2]);
	       tmp33 = (tmp29 * tmp30) - (tmp31 * tmp32);
	       tmp37 = (tmp31 * tmp30) + (tmp29 * tmp32);
	  }
	  {
	       fftw_real tmp23;
	       fftw_real tmp34;
	       fftw_real tmp43;
	       fftw_real tmp44;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp23 = tmp17 + tmp22;
	       tmp34 = tmp28 + tmp33;
	       Y[-2 * iostride] = tmp23 - tmp34;
	       X[0] = tmp23 + tmp34;
	       tmp43 = tmp28 - tmp33;
	       tmp44 = tmp40 - tmp39;
	       X[3 * iostride] = -(tmp43 + tmp44);
	       Y[-iostride] = tmp44 - tmp43;
	  }
	  {
	       fftw_real tmp41;
	       fftw_real tmp42;
	       fftw_real tmp35;
	       fftw_real tmp38;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp41 = tmp39 + tmp40;
	       tmp42 = tmp36 + tmp37;
	       X[2 * iostride] = -(tmp41 - tmp42);
	       Y[0] = tmp42 + tmp41;
	       tmp35 = tmp17 - tmp22;
	       tmp38 = tmp36 - tmp37;
	       Y[-3 * iostride] = tmp35 - tmp38;
	       X[iostride] = tmp35 + tmp38;
	  }
     }
     if (i == m) {
	  fftw_real tmp1;
	  fftw_real tmp10;
	  fftw_real tmp16;
	  fftw_real tmp4;
	  fftw_real tmp12;
	  fftw_real tmp7;
	  fftw_real tmp14;
	  fftw_real tmp9;
	  fftw_real tmp8;
	  fftw_real tmp15;
	  ASSERT_ALIGNED_DOUBLE();
	  tmp1 = X[0];
	  tmp9 = X[3 * iostride];
	  tmp8 = c_re(W[2]);
	  tmp10 = tmp8 * tmp9;
	  tmp15 = c_im(W[2]);
	  tmp16 = tmp15 * tmp9;
	  {
	       fftw_real tmp3;
	       fftw_real tmp2;
	       fftw_real tmp11;
	       fftw_real tmp6;
	       fftw_real tmp5;
	       fftw_real tmp13;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp3 = X[2 * iostride];
	       tmp2 = c_re(W[1]);
	       tmp4 = tmp2 * tmp3;
	       tmp11 = c_im(W[1]);
	       tmp12 = tmp11 * tmp3;
	       tmp6 = X[iostride];
	       tmp5 = c_re(W[0]);
	       tmp7 = tmp5 * tmp6;
	       tmp13 = c_im(W[0]);
	       tmp14 = tmp13 * tmp6;
	  }
	  Y[-iostride] = tmp10 - (tmp12 + tmp7);
	  X[0] = tmp1 + tmp4 + tmp7 + tmp10;
	  Y[0] = tmp12 + tmp14 + tmp16;
	  X[iostride] = tmp1 + tmp14 - (tmp4 + tmp16);
     }
}

static const int twiddle_order[] =
{1, 2, 3};
fftw_codelet_desc fftw_hc2hc_forward_4_desc =
{
     "fftw_hc2hc_forward_4",
     (void (*)()) fftw_hc2hc_forward_4,
     4,
     FFTW_FORWARD,
     FFTW_HC2HC,
     67,
     3,
     twiddle_order,
};
