/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/* 
 * defaults.c
 */

/*
 * Create DEFAULTS postmaster object
 */
#include <stdio.h>

#include <constants.h>
#include <defaults.h>
#include <pm.h>
#include <symbols.h>
#include <utilities.h>

static char *DEFAULTS_OBJ_NAME  = "Defaults";

static char *DEFAULTS[] = {
  "Defaults.Disp_Points",
  "Defaults.Symbol_Index",
  "Defaults.Symbols",
  "Defaults.Precision",
  "Defaults.Recording",
  "Defaults.Skip_Size", /* 8/19/97 BAM */
  "Defaults.Plot_Scale_Factor",	 /* 9/5/97 BAM */
  "Defaults.Varb_Min",
  "Defaults.Varb_Max",
  "Defaults.Param_Min",
  "Defaults.Param_Max",
  "Defaults.Funct_Min",
  "Defaults.Funct_Max",
  "Defaults.Auto_Refresh",
  "Defaults.Diverg_Cutoff",
  "Defaults.Reset"
  };

typedef enum {
  DISP_POINTS=0, SYMBOL_INDEX, SYMBOLS, PRECISION,
  RECORDING, SKIPSZ, PLOT_SCALE_FACTOR, 
  VARB_MIN, VARB_MAX, PARAM_MIN, PARAM_MAX,
  FUNCT_MIN, FUNCT_MAX, AUTO_REFRESH, DIVERG_CUTOFF, RESET
  } DEFAULTS_t;


void
  defaults_install()
{
  void defaults_reset();
  int i;

  pm(CREATE_OBJ, DEFAULTS_OBJ_NAME,
     CREATE_ELEM, DEFAULTS[DISP_POINTS], INT,
     CREATE_ELEM, DEFAULTS[SYMBOL_INDEX], INT,
     CREATE_ELEM, DEFAULTS[SYMBOLS], STRNG_LIST,
     CREATE_ELEM, DEFAULTS[PRECISION], INT,
     CREATE_ELEM, DEFAULTS[RECORDING], INT,
     CREATE_ELEM, DEFAULTS[SKIPSZ], INT,
     CREATE_ELEM, DEFAULTS[PLOT_SCALE_FACTOR], DBL,
     CREATE_ELEM, DEFAULTS[VARB_MIN], DBL_LIST,
     CREATE_ELEM, DEFAULTS[VARB_MAX], DBL_LIST,
     CREATE_ELEM, DEFAULTS[PARAM_MIN], DBL_LIST,
     CREATE_ELEM, DEFAULTS[PARAM_MAX], DBL_LIST,
     CREATE_ELEM, DEFAULTS[FUNCT_MIN], DBL_LIST,
     CREATE_ELEM, DEFAULTS[FUNCT_MAX], DBL_LIST,
     CREATE_ELEM, DEFAULTS[AUTO_REFRESH], INT,
     CREATE_ELEM, DEFAULTS[DIVERG_CUTOFF], DBL,
     CREATE_ELEM, DEFAULTS[RESET], FNCT,
     NULL);

  pm(PUT, DEFAULTS[DISP_POINTS], DISP_TRAJ_ITERS,
     PUT, DEFAULTS[SYMBOL_INDEX], DEF_SYMBOL_INDEX,
     PUT, DEFAULTS[PRECISION], DEF_PRECISION,
     PUT, DEFAULTS[RECORDING], TRUE,
     PUT, DEFAULTS[SKIPSZ], SKIP_SIZE,
     PUT, DEFAULTS[PLOT_SCALE_FACTOR], DEF_SCALE_FACTOR,
     PUT, DEFAULTS[AUTO_REFRESH], DEF_AUTO_REFRESH,
     PUT, DEFAULTS[DIVERG_CUTOFF], DEF_DIVERG_CUTOFF,
     INIT, DEFAULTS[SYMBOLS], NUM_SYM_TYPES, MAX_SHORT_STR,
     INIT, DEFAULTS[RESET],
     PUT, DEFAULTS[RESET], defaults_reset,
     NULL);

  for (i=0; i<NUM_SYM_TYPES; i++)
    pm(PUT, DEFAULTS[SYMBOLS], i, Panel_Sym_Names[i], NULL);
}


void
  defaults_reset()
{
  int v,p,f,i;

  get_n_all_types(&v,&p,&f);

  pm(INIT, DEFAULTS[VARB_MIN], v,
     INIT, DEFAULTS[VARB_MAX], v,
     INIT, DEFAULTS[PARAM_MIN], p,
     INIT, DEFAULTS[PARAM_MAX], p,
     INIT, DEFAULTS[FUNCT_MIN], f,
     INIT, DEFAULTS[FUNCT_MAX], f,
     NULL);

  for (i=0; i<v; i++)
    {
      pm(PUT, "Defaults.Varb_Min", i, 
	 *((double *) pm(GET, "Model.Varb_Min", i, NULL)), NULL);
      pm(PUT, "Defaults.Varb_Max", i, 
	 *((double *) pm(GET, "Model.Varb_Max", i, NULL)), NULL);
    }
  for (i=0; i<p; i++)
    {
      pm(PUT, "Defaults.Param_Min", i, 
	 *((double *) pm(GET, "Model.Param_Min", i, NULL)), NULL);
      pm(PUT, "Defaults.Param_Max", i, 
	 *((double *) pm(GET, "Model.Param_Max", i, NULL)), NULL);
    }
  for (i=0; i<f; i++)
    {
      pm(PUT, "Defaults.Funct_Min", i, 
	 *((double *) pm(GET, "Model.Funct_Min", i, NULL)), NULL);
      pm(PUT, "Defaults.Funct_Max", i, 
	 *((double *) pm(GET, "Model.Funct_Max", i, NULL)), NULL);
    }
}
