#
# Sendmail SMTP Relay Control by <gjermund@xyzzy.no> 1997-11-26
# Updated for Sendmail 8.9 <gjermund@xyzzy.no> 1998-10-06
#

LOCAL_CONFIG
Krelay ifelse(_ARG_, `', `hash -a:FOUND /etc/smtp.relay', `_ARG_')

LOCAL_RULESETS
SLocal_check_rcpt

# ----------------- CLIENT IP-ADDR CHECK -------------------

# Look up the client's IP address in the relay database. First A.B.C.D,
# then A.B.C, then A.B, then A, or until a match was found. If found,
# the client can relay anywhere and we exit the ruleset. 

R $*			$: $( dequote "" $&{client_addr} $) . dummy $| $1
R $+.$- $| $*		$( relay $1 $: $1 $| $3 $)
R $+:FOUND		$@ $#OK
R $+ $| $*		$: $2

# ---------------------- RCPT CHECK ------------------------

# Put everything through ruleset S3 to focus and canonicalize addresses
R $*			$: $>3 $1

# Handle some special cases (by Robert Harker):
R $+ < @ >		$: $>3 $1		user@ => user
R <@ $* >		$#error $@ 5.1.1 $: user address required

# Check that the address is local and not a user%host@my.dom type
# address (by Robert Harker):
R $* <@ $+ > $*		$: $>StripLocal $1<@$2>$3

# It's ok if the rcpt domain is not in the DNS (has no trailing dot) here
# since this might be a temporary failure and we wish to try delivery again
# later on behalf of our users. Delete any trailing dot to make all
# ready for relay database lookup.    x<@y.z.> -->  x<@y.z>
R $* <@ $* .>		$: $1 <@ $2>

# Prepend a dummy token (:) to the domain so that the first database
# lookup in the next rule will be the domain itself. x<@y.z> --> x<@:y.z>
R $* <@ $+>		$: $1 <@ :$2>

# Look up the domain in the relay database to see if it was one of the
# domains we handle mail for. If not, then this is unwanted relaying
# since the client connected from a non-local IP adress. First look up
# the domain itself (ex. "a.b.c"), then the subdomains with leading dots
# (example: ".b.c", then ".c").
#
R $* <@ $* $~. $+>	$( relay $4 $: $1<@$4> $)

# If found, then $* will now be :FOUND. Else deny relaying:
R $* <@ $+>		$#error $: We do not relay
R $*			$@ $#OK



# The following StripLocal idea and ruleset is taken from
# Robert Harker's paper from LISA'97 and slightly modified.

SStripLocal

# Note about $>StripLocal $>3 RHS syntax
# When two rulesets are specified on the RHS the firts is called,
# and then the second is imedately called before execiting the
# first rule of the first ruleset.
# This means that the second ruleset is processed first and the output
# of the second ruleset is used as the input to the first ruleset

# Dispose of source route addresses by stripping them
# The assumption is made that we are not interested in the source route
# only the final destination
R <@$+>:$+		$@ $>StripLocal $>3 $2

# Dequote "xxx"@domain:
R $- < @ $+ >			$: $(dequote $1 $) < @ $2 >

# Turn xxx%yyy@zzz into xxx@yyy if zzz is a domain we treat as local,
# since it is relaying to the yyy domain we want to check then.
# We assume mail to $j and $=w is delivered localy. There might be more
# (or other) classes to include here at different sites.

R $* $=O $* < @ $j . >		$@ $>StripLocal $>3 $1 $2 $3
R $* $=O $* < @ $=w . >		$@ $>StripLocal $>3 $1 $2 $3

# If the address still has a focus, then we will assume it is ok for no
R $* < @$* > $*		$@ $1 < @ $2 > $3		user@host.domain
 
# if this is quoted, strip the quotes and try again
R $+			$: $(dequote $1 $)		strip quotes
R $+ $=O $+		$@ $>StripLocal $>3 $1 $2 $3	try again

# Hmm, how about if the last checks match "xxx@yyy"@non-local  ?
# this should not be dequoted
