-----------------------------------------------------------------------
--          GtkAda - Ada95 binding for the Gimp Toolkit              --
--                                                                   --
-- Copyright (C) 1998 Emmanuel Briot and Joel Brobecker              --
--                                                                   --
-- This library is free software; you can redistribute it and/or     --
-- modify it under the terms of the GNU General Public               --
-- License as published by the Free Software Foundation; either      --
-- version 2 of the License, or (at your option) any later version.  --
--                                                                   --
-- This library is distributed in the hope that it will be useful,   --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of    --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details.                          --
--                                                                   --
-- You should have received a copy of the GNU General Public         --
-- License along with this library; if not, write to the             --
-- Free Software Foundation, Inc., 59 Temple Place - Suite 330,      --
-- Boston, MA 02111-1307, USA.                                       --
--                                                                   --
-- As a special exception, if other files instantiate generics from  --
-- this unit, or you link this unit with other files to produce an   --
-- executable, this  unit  does not  by itself cause  the resulting  --
-- executable to be covered by the GNU General Public License. This  --
-- exception does not however invalidate any other reasons why the   --
-- executable file  might be covered by the  GNU Public License.     --
-----------------------------------------------------------------------

with System;
with Gdk; use Gdk;

package body Gtk.Curve is

   ----------------
   -- Get_Vector --
   ----------------

   procedure Get_Vector (Curve  : in Gtk_Curve;
                         Vector : in out Gfloat_Array)
   is
      procedure Internal (Curve  : System.Address;
                          Veclen : Integer;
                          Vector : System.Address);
      pragma Import (C, Internal, "gtk_curve_get_vector");
   begin
      Internal (Get_Object (Curve), Vector'Length,
                Vector'Address);
   end Get_Vector;

   -------------
   -- Gtk_New --
   -------------

   procedure Gtk_New (Widget : out Gtk_Curve) is
      function Internal return System.Address;
      pragma Import (C, Internal, "gtk_curve_new");
   begin
      Set_Object (Widget, Internal);
   end Gtk_New;

   -----------
   -- Reset --
   -----------

   procedure Reset (Curve : in Gtk_Curve) is
      procedure Internal (Curve : System.Address);
      pragma Import (C, Internal, "gtk_curve_reset");
   begin
      Internal (Get_Object (Curve));
   end Reset;

   --------------------
   -- Set_Curve_Type --
   --------------------

   procedure Set_Curve_Type (Curve      : in Gtk_Curve;
                             Curve_Type : in Gtk_Curve_Type)
   is
      procedure Internal (Curve      : System.Address;
                          Curve_Type : Gint);
      pragma Import (C, Internal, "gtk_curve_set_curve_type");
   begin
      Internal (Get_Object (Curve), Gtk_Curve_Type'Pos (Curve_Type));
   end Set_Curve_Type;

   ---------------
   -- Set_Gamma --
   ---------------

   procedure Set_Gamma (Curve : in Gtk_Curve; Gamma : in Gfloat) is
      procedure Internal (Curve : System.Address; Gamma : Gfloat);
      pragma Import (C, Internal, "gtk_curve_set_gamma");
   begin
      Internal (Get_Object (Curve), Gamma);
   end Set_Gamma;

   ---------------
   -- Set_Range --
   ---------------

   procedure Set_Range
     (Curve : in Gtk_Curve;
      Min_X : in Gfloat;
      Max_X : in Gfloat;
      Min_Y : in Gfloat;
      Max_Y : in Gfloat)
   is
      procedure Internal
        (Curve : in System.Address;
         Min_X : in Gfloat;
         Max_X : in Gfloat;
         Min_Y : in Gfloat;
         Max_Y : in Gfloat);
      pragma Import (C, Internal, "gtk_curve_set_range");
   begin
      Internal (Get_Object (Curve), Min_X, Max_X, Min_Y, Max_Y);
   end Set_Range;

   ----------------
   -- Set_Vector --
   ----------------

   procedure Set_Vector (Curve  : in Gtk_Curve;
                         Vector : in Gfloat_Array)
   is
      procedure Internal (Curve  : System.Address;
                          Veclen : Integer;
                          Vector : System.Address);
      pragma Import (C, Internal, "gtk_curve_set_vector");
   begin
      Internal (Get_Object (Curve), Vector'Length,
                Vector'Address);
   end Set_Vector;

end Gtk.Curve;
