'''
sax_builder.py: SaxBuilder class implementation.

SaxBuilder builds a DOM-conformant grove from evenements generated by a
SAX-conformant driver.
'''

from xml.sax.saxlib import HandlerBase
from builder import Builder


class SaxBuilder(Builder, HandlerBase):
	def __init__(self):
		HandlerBase.__init__(self)
		Builder.__init__(self)

	def characters(self, char, start, length):
		self.text(char[start:start+length])

	
# Test.
if __name__ == '__main__':
#    while 1:
	from xml.sax import saxexts
	import sys, writer

	if len(sys.argv) == 1:
		print 'sax_builder.py usage: python sax_builder.py <xml_file>.'

	p = saxexts.make_parser('xmlproc')	
	dh = SaxBuilder()
	p.setDocumentHandler(dh)
	p.parse(sys.argv[1])
	p.close()

	doc = dh.document
	w = writer.XmlLineariser()
	print w.linearise(dh.document)

