////////////////////////////////////////////////////////
//
// GEM - Graphics Environment for Multimedia
//
// mark@danks.org
//
// Implementation file
//
//    Copyright (c) 1997-1998 Mark Danks.
//    For information on usage and redistribution, and for a DISCLAIMER OF ALL
//    WARRANTIES, see the file, "GEM.LICENSE.TERMS" in this distribution.
//
/////////////////////////////////////////////////////////

#include "particle.h"

#include "papi.h"

CPPEXTERN_NEW(particle)

/////////////////////////////////////////////////////////
//
// particle
//
/////////////////////////////////////////////////////////
// Constructor
//
/////////////////////////////////////////////////////////
particle :: particle()
{
	m_particle = pGenParticleGroups(1, 1000);
}

/////////////////////////////////////////////////////////
// Destructor
//
/////////////////////////////////////////////////////////
particle :: ~particle()
{
	if (m_particle < 0)
		pDeleteParticleGroups(m_particle, 1);
}

/////////////////////////////////////////////////////////
// render
//
/////////////////////////////////////////////////////////
void particle :: render(GemState *state)
{
	static double t = -23.0;
	static double dt = -0.05;
	t += dt;
	if(t < -25.0 || t > -10.0) dt = -dt;

	if (m_particle < 0)
		return;

	pCurrentGroup(m_particle);
	pVelocityD(PDCylinder, 0.0f, -0.01f, 0.35f, 0.0f, -0.01f, 0.37f, 0.021f, 0.019f);
	pColorD(1.0, PDLine, 0.8f, 0.9f, 1.0f, 1.0f, 1.0f, 1.0f);
	pSize(1.5f);
	
	pCopyVertexB(false, true);

	pSource(150, PDLine, 0.0f, 0.0f, 0.401f, 0.0f, 0.0f, 0.405f);
	
	pGravity(0.0f, 0.0f, -0.01f);
	
	pKillSlow(0.01f);
	
	pBounce(-0.05f, 0.35f, 0, PDPlane, -5, -5, 0.0f, 10, 0, 0, 0, 10, 0);
	
	pSink(false, PDPlane, 0, 0, -3, 1, 0, 0, 0, 1, 0);
	
	pMove();
	pDrawGroupp(GL_LINES);
}

/////////////////////////////////////////////////////////
// static member functions
//
/////////////////////////////////////////////////////////
void particle :: obj_setupCallback(t_class *classPtr)
{
}
