/*-----------------------------------------------------------------
LOG
    GEM - Graphics Environment for Multimedia

    A light

    Copyright (c) 1997-1998 Mark Danks. mark@danks.org
    For information on usage and redistribution, and for a DISCLAIMER OF ALL
    WARRANTIES, see the file, "GEM.LICENSE.TERMS" in this distribution.

-----------------------------------------------------------------*/

#ifndef INCLUDE_LIGHT_H_
#define INCLUDE_LIGHT_H_

#include "Nongeos/world_light.h"

/*-----------------------------------------------------------------
-------------------------------------------------------------------
CLASS
    light
    
    Creates a light which can be positioned

DESCRIPTION
    
    Inlet for a list - "poslist"
    
    "poslist" - Determines position

-----------------------------------------------------------------*/
class GEM_EXTERN light : public world_light
{
    CPPEXTERN_HEADER(light, world_light)

    public:

	    //////////
	    // Constructor
    	light();
    	
    protected:
    	
    	//////////
    	// Destructor
    	virtual ~light();

   	    //////////
    	// Set the light's position
    	void	    	lightPositionMess(float x, float y, float z);

    private:
    	    
    	//////////
    	// Static member functions
    	static void 	lightPositionMessCallback(void *data, t_floatarg x, t_floatarg y, t_floatarg z);
};

#endif	// for header file
