######################################################################
###
######################################################################
proc byteCompile? {} {
  global argv __progList setup __changeFunc __ok __desc __pageEnd
  global __editInfo __checkList module

  if {![info exists setup(preventBytecompile)]} {
    set setup(preventBytecompile) 0
  }

  if {[file exists [lindex $argv 1]/bytecompile]} {
    set byteTime [file mtime [lindex $argv 1]/bytecompile]
    set loadByteCompile 1
    foreach file [myGlob [lindex $argv 1]/*.template] {
      if {[file mtime $file] > $byteTime} {
        set loadByteCompile 0
        break
      }
    }
  } else {
    set loadByteCompile 0
  }

  ### testing if the version of the bytecompiled file is ok
  if {$loadByteCompile} {
    set IN [open [lindex $argv 1]/bytecompile]
    gets $IN; # remove the first line
    gets $IN line
    if {![regexp "^\# The Dotfile Generator version $__editInfo(version)\$" $line]} {
      set loadByteCompile 0
      puts "\nThe bytecompile file was written with an other version of"
      puts "The Dotfile Generator, skipping file.."
    } 
    close $IN
  }

  if {$loadByteCompile} {
    if {[lindex $argv 2] == "bytecompile"} exit
    uplevel \#0 source [lindex $argv 1]/bytecompile
    return loadedBCFile
  }

  if {[lindex $argv 2] != "bytecompile" && !$setup(preventBytecompile)} {
    if {([file writable [lindex $argv 1]/bytecompile] &&
         [file exists [lindex $argv 1]/bytecompile]) ||
        ([file writable [lindex $argv 1]] &&
         ![file exists [lindex $argv 1]/bytecompile]) } {
      
      set bytecompile [tk_dialog .bytecompile "Bytecompile ?" "To improve performance you can byte-compile the dotdotfiles, do you want that?" questhead 1 No Yes]
    } else {
      puts "\n\nTo improve performence, please tell the owner"
      puts "of \"[lindex $argv 1]/\" to bytecompile the module,"
      puts "which he does by typeing \"dotfile <module name> bytecompile\""
      set bytecompile 0
    }
  } else {
    if {$setup(preventBytecompile)} {
      set bytecompile 0
    } else {
      set bytecompile 1
    }
  }
  if {$bytecompile} {
    return doByteCompile
  } else {
    return dontByteCompile
  }
}

######################################################################
###
######################################################################
proc byteCompileFile {} {
  global argv __progList setup __changeFunc __ok __desc __shortDesc __pageEnd
  global __initFunc __children __widgetArgs __parent __TKargs __editInfo
  global __checkList module __hash __saveVars __showPage 
  
  ### writeing the bytecompile file
  timeWindow 12 "Byte compiling" \
      "Byte compiling the $module(name) module\nPlease wait"
         
  set OUT [open [lindex $argv 1]/bytecompile w]
  
  ### writing version info
  puts $OUT "$__hash\n\# The Dotfile Generator version $__editInfo(version)\n\# $module(name) module version $module(version)\n$__hash\n"
  
  ### saveing the module global variable
  if {[info exists __saveVars]} {
    puts $OUT "$__hash\n\# module global variables\n$__hash"
    foreach elm $__saveVars {
      upvar \#0 $elm variable
      if {[array exists variable]} {
        foreach arrayElm [array names variable] {
          puts $OUT \
              "set ${elm}($arrayElm) \"[escape $variable($arrayElm)]\""
        }
      } elseif {[info exists variable]} {
        puts $OUT "set $elm \"[escape $variable]\""
      }
    }
  }
  incrTimeWindow
  ### Is the next update important?!
  ### Fri Sep 13 13:53:59 1996 -- Jesper Pedersen
  ###  update
  
  ### writeing all my arrays
  foreach arr {__changeFunc __ok __desc __shortDesc __pageEnd __showPage
    __initFunc __children __widgetArgs __parent __TKargs} {
    puts $OUT "$__hash\n\# $arr\n$__hash"
    foreach elm [array names $arr] {
      puts $OUT "set ${arr}($elm) \"[escape [set ${arr}($elm)]]\""
    }
    incrTimeWindow
  }
  destroyTimeWindow
  
  
  close $OUT
  if {[lindex $argv 2] == "bytecompile"} exit
}

######################################################################
###
######################################################################
proc testBCVersion {} {
  global argv module 
  set IN [open [lindex $argv 1]/bytecompile]
  gets $IN; # remove the first line
  gets $IN; # remove the line about the Dot.Gen. version
  gets $IN line
  if {![regexp "^\# $module(name) module version $module(version)\$" $line]} {
    puts "\nThe bytecompile file was written with an other version of"
    puts "the $module(name) module, please delete the byte compile file!"
    exit -1
  }
}

######################################################################
### This function evaluate all the user pages, which build up the
### module.
######################################################################
proc loadFiles {} {
  global __progList __editInfo __changeFunc __ok __desc __pageEnd __checkList
  global __children __showPage __initFunc
  ### bytecompile file doesn't exist.
  timeWindow [llength $__progList] Loading "Loading Information...Please wait"
  foreach menu $__progList {
    set __editInfo(name) $menu
    set __changeFunc($menu) {}
    set __showPage($menu) {}
    set __initFunc($menu) {}
    set __ok($menu) {}
    set __desc($menu) {}
    set __pageEnd($menu) {}
    set __checkList {}
    $menu
    if {![info exists __children(${menu}__top)]} {
      error "No element defined for page \"$menu\""
    }
    unset __checkList
    incrTimeWindow
  }
  destroyTimeWindow
}
