/*
 * dlsof.h - BSDI header file for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */


/*
 * $Id: dlsof.h,v 1.1 96/01/12 10:49:36 abe Exp $
 */


#if	!defined(BSDI_LSOF_H)
#define	BSDI_LSOF_H	1

#include <stdlib.h>
#include <dirent.h>
#include <nlist.h>
#include <setjmp.h>
#include <signal.h>
#include <string.h>
#include <unistd.h>
#include <sys/filedesc.h>
#include <sys/mbuf.h>
#define	NFS
#define m_stat	mnt_stat
#include <sys/mount.h>
#include <rpc/types.h>
#include <sys/protosw.h>
#include <sys/socket.h>
#include <sys/socketvar.h>
#include <sys/un.h>
#include <sys/unpcb.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <net/route.h>
#include <netinet/in_pcb.h>
#include <sys/ucred.h>
#include <sys/vnode.h>
#include <net/raw_cb.h>
#include <sys/domain.h>
#include <sys/fcntl.h>
#include <ufs/ufs/lockf.h>
#include <isofs/cd9660/cd9660_node.h>
#undef IN_ACCESS
#undef IN_LOCKED
#undef IN_WANTED
#undef VTOI
#define KERNEL
#include <ufs/ufs/quota.h>
# if	defined(DIRBLKSIZ)
#define	DIRENT_DIRBLKSIZ	DIRBLKSIZ
#undef	DIRBLKSIZ
# endif	/* defined(DIRBLKSIZ) */

#include <ufs/ufs/inode.h>
#undef	i_rdev
#undef	i_size

# if	defined(DIRENT_BLKSIZ)
#define	DIRBLKSIZ	DIRENT_DIRBLKSIZ
#undef	DIRENT_DIRBLKSIZ
# endif	/*defined(DIRENT_BLKSIZ) */

#undef KERNEL
#include <msdosfs/direntry.h>
#include <msdosfs/fat.h>
#include <msdosfs/denode.h>
#include <ufs/mfs/mfsnode.h>
#include <nfs/nfsv2.h>
#include <nfs/nfs.h>
#include <nfs/nfsnode.h>
#include <sys/proc.h>
#include <kvm.h>
#undef	TRUE
#undef	FALSE
#include <sys/sysctl.h>
#define	P_COMM		kp_proc.p_comm
#define	P_FD		kp_proc.p_fd
#define	P_PID		kp_proc.p_pid
#define	P_PGRP		kp_eproc.e_pgid
#define	P_TEXTVP	kp_proc.p_textvp
#define	P_VMSPACE	kp_proc.p_vmspace

# if	defined(HASPROCFS)
#include <miscfs/procfs/procfs.h>
#include <machine/reg.h>
# endif	defined(HASPROCFS)

#define	KERNEL
#define _KERNEL
#include <sys/file.h>
#undef	KERNEL
#undef	_KERNEL
#include <vm/vm.h>
#include <vm/vm_map.h>
#include <vm/vm_object.h>
#include <vm/vm_pager.h>

#define	COMP_P		const void
#define DEVINCR		1024	/* device table malloc() increment */
#define	KA_T		u_long
#define	KMEM		"/dev/kmem"
#define MALLOC_P	void
#define FREE_P		MALLOC_P
#define MALLOC_S	size_t
#define N_UNIX		"/bsd"
#define QSORT_P		void
#define	READLEN_T	int
#define STRNCPY_L	size_t
#define SWAP		"/dev/drum"


/*
 * Global storage definitions (including their structure definitions)
 */

extern kvm_t *Kd;

struct l_vfs {
	struct mount *addr;		/* kernel address */
	fsid_t	fsid;			/* file system ID */
	short type;			/* type of file system */
	char *dir;			/* mounted directory */
	char *fsname;			/* file system name */
	struct l_vfs *next;		/* forward link */
};
extern struct l_vfs *Lvfs;

struct mounts {
        dev_t dev;              	/* st_dev */
        char *dir;              	/* directory */
        char *fsname;           	/* file system */
	ino_t inode;			/* st_ino */
	mode_t mode;			/* st_mode */
        struct mounts *next;    	/* forward link */
	dev_t rdev;			/* st_rdev */
};

#define	X_NCACHE	0
#define	X_NCSIZE	1

extern int Np;				/* number of kernel processes */
struct kinfo_proc *P;			/* local process table copy */
extern int pgshift;			/* kernel's page shift */

struct sfile {
	char *aname;			/* argument file name */
	char *name;			/* file name (after readlink()) */
	char *devnm;			/* device name (optional) */
	dev_t dev;			/* device */
	u_short mode;			/* S_IFMT mode bits from stat() */
	int type;			/* file type: 0 = file system
				 	 *	      1 = regular file */
	ino_t i;			/* inode number */
	int f;				/* file found flag */
	struct sfile *next;		/* forward link */

};

#endif	/* BSDI_LSOF_H */
