%{
#include <string.h>
#include "main.h"
#include "y.tab.h"
#include "utils.h"

int lineno = 1;

static char buf[1000];
static char *s;

extern void yyerror(char *s, ...);

%}

%x INSTRING

%%

"logfile"      return LOGFILE_TOK;
"redirect"     return REDIRECT_TOK;
"randomness"   return RANDOM_TOK;
"file"			return FILE_TOK;

"none"         return NONE_TOK;

"source"			return SOURCE_TOK;

"browser"		return BROWSER_TOK;

"exempt"	{
		yylval.iValue = EXEMPT;
		return EXEMPT_TOK;
	}
"hostexempt"	{
		yylval.iValue = HOSTEXEMPT;
		return EXEMPT_TOK;
	}
"pathexempt"	{
		yylval.iValue = PATHEXEMPT;
		return EXEMPT_TOK;
	}
"contains"		{
		yylval.iValue = CONTAINS;
		return CONTAINS_TOK;
	}
"hostcontains"	{
		yylval.iValue = HOSTCONTAINS;
		return CONTAINS_TOK;
	}
"pathcontains"	{
		yylval.iValue = PATHCONTAINS;
		return CONTAINS_TOK;
	}

[0-9]+			{
		yylval.iValue = atoi(yytext);
		return INTEGER;
	}

[;{}.]			{
		return *yytext;
	}


\"					{ BEGIN INSTRING; s = buf; }
<INSTRING>\\n	{ *s++ = '\n'; }
<INSTRING>\\t	{ *s++ = '\t'; }
<INSTRING>\\\"	{ *s++ = '\"'; }
<INSTRING>\"	{ 
		*s = 0;
		BEGIN 0;
		yylval.sPtr = strdup(buf);
		return STRING;
	}
<INSTRING>.		{ *s++ = *yytext; }


\n					{ lineno++; }  /* count newlines */
#.*$				; /* ignore comments */
%.*$				; /* ignore comments */
\/\/.*$			; /* ignore comments */
[ \t]+			; /* ignore whitespace */

[^ \t\n\";{}.]+	{ 
						yyerror("Unknown token \"%s\"", yytext);
					}

%%

int yywrap(void)
{
	return 1;
}
