<?php
##
## Copyright (c) 1999 Internet Images Srl
##                    Massimiliano Masserelli
##
## $Id: language.inc,v 1.2 1999/11/03 13:46:58 negro Exp $
##

  class Language {
    var $classname = "Language";
    var $persistent_slots = array("CurrentLanguage", "AcceptedLanguages");

    var $CurrentLanguage;             ## Holds the current language
    var $AcceptedLanguages = array(); ## Hashed array of allowed locales 
                                      ## in the form "short"=>"locale"
                                      ## (ie: "en"=>"en-US")

    var $clangdir = "./lang";  # Dir with compiled language files (dbm format)

    var $debuglevel = 0;
    var $language_selection = "LangSel"; ## Name of a global var used to
                                         ## select the current language.

    function init($default, $accepted) {
      $this->AcceptedLanguages = array();
      if (! is_array($accepted)) {
        return false;
      }
      while (list($short, $locale) = each($accepted)) {
        $this->AcceptedLanguages[$short] = $locale;
      }
      if (! $this->AcceptedLanguages[$this->CurrentLanguage]) {
        # Set language by browser headers or default
        $http_headers=GetAllHeaders();
        for ($tok=strtok($http_headers["Accept-Language"], ","); $tok; $tok=strtok(",")) {
          $candidate = strchr($tok, "_") ? substr($tok, strchr($tok, "_")) : $tok;
          if ($this->SetLanguage($candidate)) {
           break;
          }
        }
      }
      if(! $this->AcceptedLanguages[$this->CurrentLanguage]) {
        if (! $this->SetLanguage($default)) {
          $this->debug(2, "Invalid default language!");
          return false;
        }
      }
      return true;
    }

    function SetLanguage($language) {
      if ($this->AcceptedLanguages[$language]) {
        $this->CurrentLanguage = $language;
        return true;
      } else {
        return false;
      }
    }

    function Check() {
      global $QUERY_STRING;
      $lsn = $this->language_selection;
      if (! empty($QUERY_STRING)) {
        if ($nq = ereg_replace(
          "(^|&)".quotemeta(urlencode($this->language_selection))."=[a-z]+(&|$)",
          "\\1", $QUERY_STRING)) {
          $QUERY_STRING = ereg_replace("(^&)|(&$)", "", $nq);
        }
      }
      global $$lsn;
      if (($$lsn) && ($$lsn != $this->CurrentLanguage)) {
        if ($this->SetLanguage($$lsn)) {
          if ($this->dbhandle) {
            dbmclose($this->dbhandle);
            unset($this->dbhandle);
          }
        }
      }
      if (! $this->dbhandle) {
        if (! ($this->dbhandle = @dbmopen(sprintf("%s/%s", $this->clangdir, $this->CurrentLanguage), "r"))) {
          return false;
        }
      }
      return true;
    }

    ## This methods returns a string translated in current locale
    function String($keyword) {
      if (($this->Check()) && ($string = dbmfetch($this->dbhandle, $keyword))) {
        return $string;
      } else {
        return $keyword;
      }
    }

    ## Shorthand
    function f($keyword) {
      return $this->String($keyword);
    }

    ## Shorthand 
    function p($keyword) {
      printf("%s", $this->String($keyword));
      return true;
    }

    function debug($level, $string) {
      if ($this->debuglevel >= $level) {
        printf("%s", $string);
      }
      return true;
    }
    
    ## Sets the current locale for using in locale-enabled PHP3 functions
    function setlocale() {
      $this->Check();
      return setlocale(LC_ALL, $this->AcceptedLanguages[$this->CurrentLanguage]);
    }

    ## Resets the standard locale in order to avoid problems with logging
    ## and other locale related undesiderable behaviours. See the PHP3
    ## bug database for further informations.
    function resetlocale() {
      return setlocale(LC_ALL, "C");
    }
  }

  ## 
  ## Global functions, to minimize the impact on the readability of the
  ## HTML code. The _() mimics the GNU gettext suggested macro, _P()
  ## is used to print the string, and is to be used mostly in "plain" 
  ## HTML code.
  ## 
  ## Those functions are provided as example, and are commented out
  ## to avoid pollution of the name space. You are encouraged to
  ## uncomment them or provide similar shorthands in your code.
  ##

  #function _($keyword) {
  #  global $lang;
  #  return $lang->f($keyword);
  #}
  
  #function _P($keyword) {
  #  global $lang;
  #  return $lang->p($keyword);
  #}

?>
