<?php
 ## Config: Path to font and font sizes
 $font  = "/dos/c/windows/fonts/arialbd.ttf";
 $fsize = array(16, 14, 12, 10, 8);

 ## Config: Path to cache
 $cache= "./cache";

 ## Config: Button size
 $w    = 120; 
 $h    = 20; 

 ## Sanitize args
 settype($level, "integer");
 if ($level <1)              $level = 1;
 if ($level > count($fsize)) $level = count($fsize);
 $selected = $selected?1:0;
 $hilite   = $hilite?1:0;
 $level--; ## comment out if desired (Menu_Button starts levels at 1)


 ## Filename in cache directory
 $hash = md5("$text:$level:$selected:$hilite");
 
 ## Cache filename, do not change
 $file = "$cache/$hash.gif";
 
 ## If cache does not exist, try to create it.
 if (!file_exists($cache) or !is_dir($cache)) {
   mkdir($cache, 0755) or die;
 }

 ## If file is not in Cache, create it
 if (!file_exists($file)) {
   $im    = Imagecreate($w, $h);

   $tx_unselected = Imagecolorallocate($im,   0,   0,   0);
   $tx_selected   = Imagecolorallocate($im, 255, 255, 255);

   $lo_selected   = Imagecolorallocate($im,  64, 128,  64);
   $hi_selected   = Imagecolorallocate($im, 192, 128, 128);

   $colbase = 255;
   $colstep = -16;
   for ($i=0; $i<count($fsize); $i++) {
     $col = $colbase+$colstep*$i;
     $locolor[$i] = Imagecolorallocate($im, $col, 255, $col);
     $hicolor[$i] = Imagecolorallocate($im, 255, $col, $col);
   }

   if ($hilite)   
     $bg = $selected?$hi_selected:$hicolor[$level];
   else
     $bg = $selected?$lo_selected:$locolor[$level];
   
   $tx = $selected?$tx_selected:$tx_unselected;
   
   imagefilledrectangle($im, 0, 0, $w, $h, $bg);
   imagettftext($im, $fsize[$level], 0, 8*$level, $h-5, $tx, $font, $text);
   
   ## imagepng($im, $file); since a few weeks.
   imagegif($im, $file); 
 }
 
 ## header("Content-Type: image/png"); since a few weeks
 header("Content-Type: image/gif");
 readfile($file);

?>
