#ifndef __BROWSER_H__
#define __BROWSER_H__

#include <gdk/gdk.h>
#include <gtk/gtkvbox.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define WIDTH 400
#define HEIGHT 320

#define BROWSER(obj)          GTK_CHECK_CAST (obj, browser_get_type (), Browser)
#define BROWSER_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, browser_get_type (), BrowserClass)
#define IS_BROWSER(obj)       GTK_CHECK_TYPE (obj, browser_get_type ())


typedef struct _Browser       Browser;
typedef struct _BrowserClass  BrowserClass;

struct _Browser
{
  GtkVBox vbox;
  
/*  GtkWidget *text;*/
  GtkWidget *html;

#if 0
  char url[URL_LEN];
  char buf[BUF_LEN];
  char *hdr, *src; /* beginning of source, after header */
#endif
};

struct _BrowserClass
{
  GtkVBoxClass parent_class;

  void (* browser) (Browser *ttt);
};

guint          browser_get_type        (void);
GtkWidget*     browser_new             (void);
void           browser_clear           (Browser *b);
int browser_display_src(Browser *b, char *src);
#if 0
int            browser_set_url         (Browser *b, char *url);
char *         browser_get_url         (Browser *b);
char *         browser_get_hdr         (Browser *b);
char *         browser_get_src         (Browser *b);
#endif

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __BROWSER_H__ */
