/*
 * setup.c  -  Setup netboot module
 *
 * Copyright (C) 1998 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define NO_BINARY 1	/* No need to include binary support here */
#include "common.h"
#include "nblib.h"
#include "privlib.h"



/*
 * Default file and path names
 */
#ifndef DEFAULT_CONFIG
#define DEFAULT_CONFIG	"//netboot.config"
#endif
#ifndef DEFAULT_DIR
#define DEFAULT_DIR	"."
#endif
#define DATABASE	"//netboot.db"



/*
 * Variables private to this module
 */
static char *confnetbootdir = NULL;	/* netboot directory name from config */



/*
 * Global variables exported by this module
 */
char *configname = NULL;	/* name of configuration file */
char *netbootdir = NULL;	/* main netboot directory */
char *dbname = NULL;		/* name of system database file */



/*
 * Definition of general section in configuration file
 */
static struct paramdef general_params[] = {
	{ "netbootdir",	par_string,	NULL,	{&confnetbootdir}},
	{ "database",	par_string,	NULL,	{&dbname}},
	{ NULL,		par_null,	NULL,	{NULL}}
};

static struct sectdef general_sects[] = {
	{ "general",	general_params,	NULL,	NULL },
	{ NULL,		NULL,		NULL,	NULL }
};



/*
 * Setup netboot module program
 */
void nbsetup(argc, argv, opts, sects)
int argc;
char **argv;
struct cmdopt *opts;
struct sectdef *sects;
{
  struct sectdef *sectbuf = NULL;
  struct sectdef *cursect = NULL;
  char *defaultdir = NULL;
  int sectnum, gensectnum;

  /*
   * Process command line options
   */
  parseopt(argc, argv, opts);

  /*
   * Normalize name of configuration file, set default if not given on
   * command line.
   */
  copystr(&defaultdir, DEFAULT_DIR);
  if (netbootdir == NULL)
	netbootdir = defaultdir;
  setpath(&configname, DEFAULT_CONFIG);
  if (netbootdir == defaultdir)
	netbootdir = NULL;
  if (defaultdir != NULL)
	free(defaultdir);

  /* Setup temporary buffer for sections */
  for (sectnum = 0, cursect = sects;
       cursect != NULL && cursect->name != NULL; cursect++)
	sectnum++;
  gensectnum = sizeof(general_sects) / sizeof(struct sectdef);
  sectbuf = nbmalloc(sizeof(struct sectdef) * (sectnum + gensectnum + 1));
  memcpy(&sectbuf[0], sects, sizeof(struct sectdef) * sectnum);
  memcpy(&sectbuf[sectnum], general_sects, sizeof(struct sectdef) * gensectnum);

  /* Read config file */
  readconfig(sectbuf);
  free(sectbuf);

  /* Finally normalize all pathnames */
  if (netbootdir == NULL) {
	if (confnetbootdir != NULL)
		copystr(&netbootdir, confnetbootdir);
	else
		copystr(&netbootdir, DEFAULT_DIR);
  }
  if (confnetbootdir != NULL)
	free(confnetbootdir);
  setpath(&dbname, DATABASE);
}

