static char rcsid[] = "$Id: nmin.c,v 1.3 1997/07/18 03:02:36 dhb Exp $";

/*
** $Log: nmin.c,v $
** Revision 1.3  1997/07/18 03:02:36  dhb
** Fix for getopt problem; getopt(), optopt and optind are now
** G_getopt(), G_optopt and G_optind.
**
** Revision 1.2  1993/02/24 21:15:47  dhb
** 1.4 to 2.0 command argument changes.
**
** Revision 1.1  1992/12/11  19:06:00  dhb
** Initial revision
**
*/

/* By : Upinder S. Bhalla, 1992, Caltech */
#include <stdio.h>
#include <math.h>
#include "olf_ext.h"

float *vector();
void free_vector();
int find_nmin();

#define NDIMS 20
#define TOLERANCE 0.0002
#define DX 0.001
#define EPS 1.0e-8

#define ITMAX 200

#define NONE 0
#define FRESH 1
#define GRAD1LO 2
#define GRAD1HI 3
#define GRAD2LO 4
#define GRAD2HI 5
#define LINMIN 6


int nmin(argc,argv)
	int argc;
	char	**argv;
{
	static float *p;
	float match;
	int iter,i,ndim;
	struct table_type	*table;
	static int ret = 1;
	int	exp_flag=0,init_flag=0;
	float tolerance;
	int	status;

	tolerance = TOLERANCE;

/* Handle io options */
	initopt(argc, argv, "ndim table-element match -exponential -initialize -tolerance t");
	while ((status = G_getopt(argc, argv)) == 1)
	  {
	    if (strcmp(G_optopt, "-exponential") == 0)
		exp_flag=1;
	    if (strcmp(G_optopt, "-initialize") == 0)
		init_flag=1;
	    if (strcmp(G_optopt, "-tolerance") == 0)
		tolerance=Atof(optargv[1]);
	  }

	if (status < 0) {
		printoptusage(argc, argv);
		return(-1);
	}

	ndim=atoi(optargv[1]);
	if (ndim <=0) {
		printf("Error : ndim = %d must be > 0\n",ndim);
		return(-1);
	}
	table=(struct table_type *) GetElement(optargv[2]);
	if (!table) {
		printf("Error : table element %s not found\n",optargv[2]);
		return(-1);
	}
	if (strcmp(table->object->name,"table") !=0) {
		printf("Error : element %s is not of type table\n",optargv[2]);
		return(-1);
	}
	if (!table->alloced) {
		printf("Error : table %s is not allocated\n",optargv[2]);
		return(-1);
	}
	if (table->table->xdivs < ndim) {
		printf("Error : table %s is size %d, less than ndim=%d\n",
			optargv[2],table->table->xdivs,ndim);
		return(-1);
	}
	match=Atof(optargv[3]);

	/* Moved out of if statement because of possible pointer 
	** errors in sim, leaking over to here */
	if (ret) {
		p=vector(1,ndim); /* Stupid num rec convention */
		if (init_flag) {
			if (exp_flag) {
				for(i=1;i<=ndim;i++) p[i]=log(table->table->table[i-1]);
			} else  {
				for(i=1;i<=ndim;i++) p[i]=table->table->table[i-1];
			}
		} else {
			for(i=1;i<=ndim;i++) p[i]=0.0;
		}
	}
/* Do minimization */
	ret=find_nmin(p,ndim,match,tolerance);
	if (exp_flag)
		for(i=1;i<=ndim;i++) table->table->table[i-1]=exp(p[i]);
	else 
		for(i=1;i<=ndim;i++) table->table->table[i-1]=p[i];
	table->output=match;
	if (ret)
		free_vector(p,1,ndim);
	return(ret);
}

int find_nmin(p,ndim,match,tolerance)
	float *p;
	int ndim;
	float match;
	float tolerance;
{
static float *ptemp,*xi,fret;
static int state=FRESH,laststate=NONE;
static float *g,*h;
static int i,j,k;
static float fp;
static float temp;
static int its;
static float gg,gam,dgg;

	/* finish up what was left over to do from last time */
	switch(laststate) {
		case FRESH :
			fp=match;
			break;
		case GRAD1LO :
		case GRAD2LO :
			p[i]=temp; /* restore previous value */
			xi[i]= -match;
			break;
		case GRAD1HI :
			p[i]=temp;
			xi[i]+=match;
			xi[i]/=2.0*DX;	/* finish off evaluation of gradient */
			i++;
			if (state==LINMIN) { /* initializing for minimization */
				for(j=1;j<=ndim;j++){
					g[j]= -xi[j];
					xi[j]=h[j]=g[j];
				}
				its=1;
				/* since p is being used for reporting params to the
				** simulation func */
				for(k=1;k<=ndim;k++) ptemp[k]=p[k];
			}
			break;
		case GRAD2HI :
			p[i]=temp;
			xi[i]+=match;
			xi[i]/=2.0*DX;	/* finish off evaluation of gradient */
			i++;
			if (state==LINMIN) { /* initializing for minimization */
		        dgg=gg=0.0;
        		for (j=1;j<=ndim;j++) {
            		gg += g[j]*g[j];
/* 			        dgg += xi[j]*xi[j];   */
            		dgg += (xi[j]+g[j])*xi[j];
        		}
        		if (gg == 0.0) {
            		/* do cleanup stuff here */
            		return(1);
        		}
        		gam=dgg/gg;
        		for (j=1;j<=ndim;j++) {
            		g[j] = -xi[j];
            		xi[j]=h[j]=g[j]+gam*h[j];
        		}
				its++;
				if (its>ITMAX) {
					printf("Error : too many iterations in GRAD2HI\n");
					return(-1);
				}
				/* since p is being used for reporting params to the
				** simulation func */
				for(k=1;k<=ndim;k++) ptemp[k]=p[k];
			}
			break;
		case LINMIN :
			if (state==GRAD2LO) {
				/* Set the value of the returned function call at p */
				fp=match;
			}
			break;
		default :
			break;
	}
	laststate=state;

	switch(state) {
		case FRESH :
			/* Initialization */
			ptemp=vector(1,ndim); /* Stupid num rec convention */
			for(i=1;i<=ndim;i++) 
				ptemp[i]=p[i];
			g=vector(1,ndim);
			h=vector(1,ndim);
			xi=vector(1,ndim);
			i=1;
			state=GRAD1LO;
			break;
		case GRAD1LO :
			/* requests the function value at small basis vector
			** offsets in order to calculate gradients */
			temp=p[i];
			p[i]=temp-DX;
			state=GRAD1HI; /* evaluate lo end of gradient */
			break;
		case GRAD1HI :
			p[i]=temp+DX;
			if (i>=ndim) { /* This is the last eval in GRAD1HI */
				state=LINMIN;
			} else
				state=GRAD1LO; /* evaluate hi end of gradient */
			break;
		case LINMIN :
			j=upilinmin(ptemp,xi,ndim,match,p,tolerance);
			fret=match;

			if (j==1) { /* finished minimization */
				/* The pt to be evaluated is now ptemp */
				for(k=1;k<=ndim;k++) p[k]=ptemp[k];
				if (2.0*fabs(fret-fp) <=
					tolerance*(fabs(fret)+fabs(fp)+EPS)) {
					/* free stuff here */
					free_vector(ptemp,1,ndim);
					free_vector(g,1,ndim);
					free_vector(h,1,ndim);
					free_vector(xi,1,ndim);
					return(1); /* finally done */
				}
				/* Since we could not predict what the last eval
				** in LINMIN would be, we have to set off the next
				** state from here itself. It is just a function
				** evaluation. The following state will be gradient
				** calculation */
				for(i=1;i<ndim;i++) p[i]=ptemp[i];

				/* if it got here, then it did find a line min, but
				** not the final answer. So we go and do another 
				** grad evaluation */
				i=1;
				state=GRAD2LO;
			}
			break;
		case GRAD2LO :
			/* requests the function value at small basis vector
			** offsets in order to calculate gradients */
			temp=p[i];
			p[i]=temp-DX;
			state=GRAD2HI; /* evaluate lo end of gradient */
			break;
		case GRAD2HI :
			p[i]=temp+DX;
			if (i>=ndim) { /* This is the last eval in GRAD1HI */
				state=LINMIN;
			} else
				state=GRAD2LO; /* evaluate hi end of gradient */
			break;
		default :
			printf("Error : state should never be here \n");
			break;
	}
	return(0);
}

#undef NDIMS 
#undef TOLERANCE
#undef DX
#undef EPS

#undef ITMAX

#undef NONE
#undef FRESH
#undef GRAD1LO
#undef GRAD1HI
#undef GRAD2LO
#undef GRAD2HI
#undef LINMIN


#define GOLD 1.618034
#define GLIMIT 100.0
#define TINY 1.0e-20
#define MAXEST(a,b) ((a) > (b) ? (a) : (b))
#define SIGN(a,b) ((b) > 0.0 ? fabs(a) : -fabs(a))
#define SHFT(a,b,c,d) (a)=(b);(b)=(c);(c)=(d);

#define INIT 1
#define FA 2
#define FB 3
#define LOOP1 4
#define LOOP2 5
#define LOOP3 6

static int ncom=0;	/* defining declarations */
static float *pcom=0,*xicom=0;

static void setp(p,x)
	float *p;
	float x;
{
	int i;

	for(i=1;i<=ncom;i++) p[i]=pcom[i]+x*xicom[i];
}

int upibrak(ax,bx,cx,fa,fb,fc,p,match)
float *ax,*bx,*cx,*fa,*fb,*fc;
float *p,match;
{
	static float ulim,u,r,q,fu,dum;
	static int state = INIT;
	static int laststate = INIT;
	float	ftemp;

	switch(laststate) {
		case FB :
			*fc=match;
			break;
		case LOOP1 :
			if (state==LOOP2 || state==LOOP3)
				fu=match;
			if (state==LOOP1) {
				fu=match;
				SHFT(*ax,*bx,*cx,u)
				SHFT(*fa,*fb,*fc,fu)
			}
			break;
		case LOOP2 :
			fu=match;
			SHFT(*ax,*bx,*cx,u)
			SHFT(*fa,*fb,*fc,fu)
			break;
		case LOOP3 :
			ftemp=match;
			SHFT(*fb,*fc,fu,ftemp)
			SHFT(*ax,*bx,*cx,u)
			SHFT(*fa,*fb,*fc,fu)
			break;
	}

	laststate=state;

	switch(state) {
		case INIT :
			setp(p,*ax);
			state=FA;
			break;
		case FA :
			*fa=match;
			setp(p,*bx);
			state=FB;
			break;
		case FB :
			*fb=match;
			if (*fb > *fa) {
				SHFT(dum,*ax,*bx,dum)
				SHFT(dum,*fb,*fa,dum)
			}
			*cx=(*bx)+GOLD*(*bx-*ax);
			setp(p,*cx);
			state=LOOP1;
			break;
		case LOOP1 :
			if (*fb > *fc){
				r=(*bx-*ax)*(*fb-*fc);
				q=(*bx-*cx)*(*fb-*fa);
				u=(*bx)-((*bx-*cx)*q-(*bx-*ax)*r)/
					(2.0*SIGN(MAXEST(fabs(q-r),TINY),q-r));
				ulim=(*bx)+GLIMIT*(*cx-*bx);
				if ((*bx-u)*(u-*cx) > 0.0) {
					setp(p,u);
					state=LOOP2;
				} else if ((*cx-u)*(u-ulim) > 0.0) {
					setp(p,u);
					state=LOOP3;
				} else if ((u-ulim)*(ulim-*cx) >= 0.0) {
					u=ulim;
					setp(p,u);
					state=LOOP1;
				} else {
					u=(*cx)+GOLD*(*cx-*bx);
					setp(p,u);
					state=LOOP1;
				}
			} else {
				laststate=state=INIT;
				return(1);
			}
			break;
		case LOOP2 :
			if (fu < *fc) {
				*ax=(*bx);
				*bx=u;
				*fa=(*fb);
				*fb=fu;
				laststate=state=INIT;
				return(1);
			} else if (fu > *fb) {
				*cx=u;
				*fc=fu;
				laststate=state=INIT;
				return(1);
			}
			u=(*cx)+GOLD*(*cx-*bx);
			setp(p,u);
			state=LOOP1;
			break;
		case LOOP3 :
			if (fu < *fc) {
				SHFT(*bx,*cx,u,*cx+GOLD*(*cx-*bx))
				setp(p,u);
				state=LOOP1;
			}
			break;
	}
	return(0);
}


#undef GOLD
#undef GLIMIT
#undef TINY
#undef MAXEST
#undef SIGN
#undef SHFT


#define ITMAX 100
#define CGOLD 0.3819660
#define ZEPS 1.0e-10
#define SIGN(a,b) ((b) > 0.0 ? fabs(a) : -fabs(a))
#define SHFT(a,b,c,d) (a)=(b);(b)=(c);(c)=(d);

#define NONE 0
#define INIT 1
#define LOOP 2

/* fx used to be returned, but it is passed in now as match */
int upibrent(ax,bx,cx,tol,xmin,peval,match) 
float ax,bx,cx,tol,*xmin;
float *peval,match;
{
	static int iter;
	static float a,b,d,etemp,fu,fv,fw,fx,p,q,r,tol1,tol2,u,v,w,x,xm;
	static float e=0.0;
	static int state=INIT;
	static int laststate=NONE;

	switch(laststate) {
		case INIT :
			fw=fv=fx=match;
			break;
		case LOOP :
			fu=match;
			if (fu <= fx) {
				if (u >= x) a=x; else b=x;
				SHFT(v,w,x,u)
				SHFT(fv,fw,fx,fu)
			} else {
				if (u < x) a=u; else b=u;
				if (fu <= fw || w == x) {
					v=w;
					w=u;
					fv=fw;
					fw=fu;
				} else if (fu <= fv || v == x || v == w) {
					v=u;
					fv=fu;
				}
			}
			iter++;
			if (iter>ITMAX) {
				*xmin=x;
				return(-1);
			}
			break;
		}
	laststate=state;

	switch(state) {
		case INIT :
			iter=0;
			a=((ax < cx) ? ax : cx);
			b=((ax > cx) ? ax : cx);
			x=w=v=bx;
			setp(peval,x);
			state=LOOP;
			break;
		case LOOP :
			xm=0.5*(a+b);
			tol2=2.0*(tol1=tol*fabs(x)+ZEPS);
			if (fabs(x-xm) <= (tol2-0.5*(b-a))) {
				*xmin=x;
				state=INIT;
				laststate=NONE;
				return(1);
			}
			if (fabs(e) > tol1) {
				r=(x-w)*(fx-fv);
				q=(x-v)*(fx-fw);
				p=(x-v)*q-(x-w)*r;
				q=2.0*(q-r);
				if (q > 0.0) p = -p;
				q=fabs(q);
				etemp=e;
				e=d;
				if (fabs(p) >= fabs(0.5*q*etemp) || p <= q*(a-x) || p >= q*(b-x))
					d=CGOLD*(e=(x >= xm ? a-x : b-x));
				else {
					d=p/q;
					u=x+d;
					if (u-a < tol2 || b-u < tol2)
						d=SIGN(tol1,xm-x);
				}
			} else {
				d=CGOLD*(e=(x >= xm ? a-x : b-x));
			}
			u=(fabs(d) >= tol1 ? x+d : x+SIGN(tol1,d));
			setp(peval,u);
			break;
	}
	return(0);
}


#undef ITMAX
#undef CGOLD
#undef ZEPS
#undef SIGN
#undef NONE
#undef INIT
#undef LOOP

#define MIN_INIT 1
#define MIN_BRAK 2
#define MIN_BRENT 3


int upilinmin(p,xi,n,match,peval,tolerance)
	float p[],xi[],match;
	float *peval;
	int n;
	float tolerance;
{
	static int state=MIN_INIT;
	static float xx,xmin,fx,fb,fa,bx,ax;
	int		i,j;


	switch (state) {
		case MIN_INIT :
			pcom=vector(1,n);
			xicom=vector(1,n);
			for (j=1;j<=n;j++) {
				pcom[j]=p[j];
				xicom[j]=xi[j];
			}
			ax=0.0;
			xx=1.0;
			bx=2.0;
			ncom=n;
			j=upibrak(&ax,&xx,&bx,&fa,&fx,&fb,peval,match);
			if (j==1)
				state=MIN_BRENT;
			else
				state=MIN_BRAK;
			break;
		case MIN_BRAK :
			i=upibrak(&ax,&xx,&bx,&fa,&fx,&fb,peval,match);
			if(i==1) {
				state=MIN_BRENT;
                i=upibrent(ax,xx,bx,tolerance,&xmin,peval,match);
                if(i==1) {
                    for (j=1;j<=n;j++) {
                        xi[j] *= xmin;
                        p[j] += xi[j];
                    }
                    state=MIN_INIT;
                    free_vector(pcom,1,n);
                    free_vector(xicom,1,n);
                    return(1);
                }
			}
			break;
		case MIN_BRENT:
			i=upibrent(ax,xx,bx,tolerance,&xmin,peval,match);
			if(i==1) {
				for (j=1;j<=n;j++) {
					xi[j] *= xmin;
					p[j] += xi[j];
				}
				state=MIN_INIT;
				free_vector(pcom,1,n);
				free_vector(xicom,1,n);
				return(1);
			}
			break;
	}
	return(0);
}

#undef MIN_INIT
#undef MIN_BRAK
#undef MIN_BRENT

/*
float *vector(nl,nh)
int nl,nh;
{
	float *v;

	v=(float *)malloc((unsigned) (nh-nl+1)*sizeof(float));
	if (!v) {
		printf("Failed to allocate vector %d %d\n",nl,nh);
		exit(1);
	}
	return v-nl;
}

void free_vector(v,nl,nh)
float *v;
int nl,nh;
{
	free((char*) (v+nl));
}
*/
