static char rcsid[] = "$Id: newmatch.c,v 1.4 1997/07/18 03:02:36 dhb Exp $";

/*
** $Log: newmatch.c,v $
** Revision 1.4  1997/07/18 03:02:36  dhb
** Fix for getopt problem; getopt(), optopt and optind are now
** G_getopt(), G_optopt and G_optind.
**
** Revision 1.3  1994/08/08 22:14:45  dhb
** Changes from Upi.
**
** Revision 1.3  1994/06/13  22:39:31  bhalla
** Replaced the missing options for using either a table or a file
**
 * Revision 1.2  1994/06/06  15:59:58  bhalla
 * Changed to use load_file_or_table rather than fopen
 *
 * Revision 1.1  1994/05/31  19:24:13  bhalla
 * Initial revision
 *
** Revision 1.2  1993/02/24  21:15:47  dhb
** 1.4 to 2.0 command argument changes.
**
** Revision 1.1  1992/12/11  19:05:59  dhb
** Initial revision
**
*/

#include <stdio.h>
#include <math.h>
#include "sim_ext.h"
#include "olf_struct.h"

int find_spike();
float do_newmatch();
float	est_max();
float	est_min();
float	do_stats();
void	altspline();
float NewStats();


#define MAXPTS 5000
#define MAXSPKS 500
#define MIN_SHAPE_SAMPLES 8

#define SN 0
#define SX 1
#define SY 2
#define SL 3
#define SL2 4
#define SH 5
#define SH2 6
#define SP 7
#define SP2 8
#define SS 9
#define ST 10
#define SW 11
#define NPARMS 12

#define SNSIMSPK 14
#define SNREFSPK 15

#define NSUM 16

static float default_wt[]={
	0.1,	/* SN number */
	10.0,	/* SX time scaling charging curves */
	10.0,	/* SY amplitude scaling charging curves */
	1.0,	/* SL low pt on spikes */
	0.0,	/* SL2 low pt on spikes, only if below ref */
	1.0,	/* SH pk of spks */
	0.0,	/* SH2 pk of spks, only if below ref */
	1.0,	/* SP PTP of spks */
	0.0,	/* SP2 PTP of spks only if below ref */
	10.0,	/* SS Spike Shape -- very important parm */
	10.0,	/* ST Timing of individual spikes */
	1.0,	/* SW Width of individual spikes */
};

#ifdef STANDALONE
main(argc,argv)
	int		argc;
	char	**argv;
{
	printf("%f\n",do_newmatch(argc,argv));
}
#endif

float do_newmatch(argc,argv)
	int		argc;
	char	**argv;
{
	FILE	*simfile,*reffile,*fopen();
	float match;
	int i,j;
	float *sim,*simt,*ref,*reft;
	int 	nsim,nref;
	int		plot_flag=0,verbose_flag=0;
	float	Atof();
	float	*sum,*sumsq;
	struct table_type *wtelm,*resultelm;
	float	*wt;
	int	status;

	wtelm=NULL;
	resultelm=NULL;

	wt = (float *)calloc(NSUM,sizeof(float));
	for(i=0;i<NPARMS;i++) wt[i]=default_wt[i];

	initopt(argc, argv, "ref-file-or-table sim-file-or-table -weight table-element -result table-element -n nspike-wt -x scalex-wt -y scaley-wt -low lo-wt -high hi-wt -toolow too-lo-wt -toohigh too-hi-wt -ptp ptp-wt -toosmallptp too-small-ptp-wt -shape shape-wt -time time-wt -width width-wt -display -verbose");
	while ((status = G_getopt(argc, argv)) == 1)
	  {
	    if (strcmp(G_optopt, "-weight") == 0)
	      {
		wtelm=(struct table_type *)GetElement(optargv[1]);
		if (!wtelm ||
			strcmp(wtelm->object->name,"table")!=0) {
			printf("Error : could not find table elm %s\n",
				optargv[1]);
			return(100);
		}
		if (wtelm->alloced && wtelm->table->xdivs>=NPARMS)
				for(j=0;j<NPARMS;j++)
					wt[j]=wtelm->table->table[j];
		else
			printf("Warning : table %s too small. Using default wts\n",optargv[1]);
	      }
	    else if (strcmp(G_optopt, "-result") == 0)
	      {
		resultelm=(struct table_type *)GetElement(optargv[1]);
		if (!resultelm ||
			strcmp(resultelm->object->name,"table")!=0) {
			printf("Error : could not find table elm %s\n",
				optargv[1]);
			return(100);
		}
	      }
	    else if (strcmp(G_optopt, "-display") == 0)
		plot_flag=1;
	    else if (strcmp(G_optopt, "-verbose") == 0)
		verbose_flag=1;
	    else if (strcmp(G_optopt, "-x") == 0)
		wt[SX]=Atof(optargv[1]);
	    else if (strcmp(G_optopt, "-y") == 0)
		wt[SY]=Atof(optargv[1]);
	    else if (strcmp(G_optopt, "-low") == 0)
		wt[SL]=Atof(optargv[1]);
	    else if (strcmp(G_optopt, "-toolow") == 0)
		wt[SL2]=Atof(optargv[1]);
	    else if (strcmp(G_optopt, "-high") == 0)
		wt[SH2]=Atof(optargv[1]);
	    else if (strcmp(G_optopt, "-ptp") == 0)
		wt[SP]=Atof(optargv[1]);
	    else if (strcmp(G_optopt, "-toosmallptp") == 0)
		wt[SP2]=Atof(optargv[1]);
	    else if (strcmp(G_optopt, "-shape") == 0)
		wt[SS]=Atof(optargv[1]);
	    else if (strcmp(G_optopt, "-time") == 0)
		wt[ST]=Atof(optargv[1]);
	    else if (strcmp(G_optopt, "-width") == 0)
		wt[SW]=Atof(optargv[1]);
	    else if (strcmp(G_optopt, "-nspike") == 0)
		wt[SN]=Atof(optargv[1]);
	  }

	if (status < 0) {
		printoptusage(argc, argv);
		free(wt);
		return(0);
	}

    if ((nref = (load_file_or_table(optargv[1],&reft, &ref))) < 1) {
		free(wt);
        return(0);
	}
    if ((nsim = (load_file_or_table(optargv[2],&simt, &sim))) < 1) {
        free(ref);
        free(reft);
		free(wt);
        return(0);
    }

	sum = (float *)calloc(NSUM,sizeof(float));
	sumsq = (float *)calloc(NSUM,sizeof(float));

	NewMatch(ref,reft,nref,sim,simt,nsim,
		1,0.0,0.0,0.03,0.03,sum,sumsq,plot_flag);

	match=NewStats(sum,sumsq,wt,resultelm,verbose_flag);

	free(wt);
	free(sim);
	free(simt);
	free(ref);
	free(reft);
	free(sum);
	free(sumsq);

	return(match);
}

float NewStats(sum,sumsq,wt,table,verbose_flag)
	float *sum,*sumsq,*wt;
	struct table_type *table;
	int verbose_flag;
{
	float ret=0.0;
	int i;

	for(i=0;i<NPARMS;i++) {
		if (table && table->alloced && table->table->xdivs >= NPARMS) {
			table->table->table[i]=sumsq[i];
		}
		ret+=sumsq[i]*wt[i];
	}
	if (verbose_flag) {
		for(i=0;i<NPARMS;i++)
			printf("%d: %f  ",i,sumsq[i]);
		printf("\n");
	}
	return(ret);
}


NewMatch(ref,reft,nref,sim,simt,nsim,
	autoest,user_maxest, user_minest, maxwindow,minwindow,
	sum,sumsq,plot_flag)
	float	*ref;
	float	*reft;
	int		nref;
	float	*sim;
	float	*simt;
	int		nsim;
	int		autoest;
	float	user_maxest,user_minest,maxwindow,minwindow;
	float	*sum,*sumsq;
	int		plot_flag;
{
	int		i,j;
	int		nrefspk,nsimspk;
	int		spikeindex,lastspikeindex;
	float	maxest,minest;
	float	refmax_mean;
	float	refmax_err;
	float	refmin_mean;
	float	refmin_err;
	float	simmax_mean;
	float	simmax_err;
	float	simmin_mean;
	float	simmin_err;
	float	max,min,refmax,refmin;
	float	refspkwidth,simspkwidth;
	int		hi,lo;
	float	x,y,dy;
	int		*refspk,*simspk,*badspk;
	float	*indarray;
	int		start,end;
	float	ret;
	float	simlo,reflo;
	int		*simsteepsamples,*refsteepsamples;
	float	temp;
	int		npts=0;
	int		nbadspk=0;
	float	*refptp,*simptp;
	FILE	*rout,*sout,*fopen();

	if (plot_flag) {
		rout=fopen("rout","w");
		sout=fopen("sout","w");
	}

	refspk=(int *)calloc(MAXSPKS,sizeof(int));
	simspk=(int *)calloc(MAXSPKS,sizeof(int));
	badspk=(int *)calloc(MAXSPKS,sizeof(int));
	refptp=(float *)calloc(MAXSPKS,sizeof(float));
	simptp=(float *)calloc(MAXSPKS,sizeof(float));
	refsteepsamples=(int *)calloc(MAXSPKS,sizeof(int));
	simsteepsamples=(int *)calloc(MAXSPKS,sizeof(int));

	for(i=0;i<NSUM;i++) sum[i]=sumsq[i]=0.0;
	
	/* Setting the max and min values for the spike peaks */
	if (autoest) {
		maxest = est_max(ref,nref);
		minest = est_min(ref,nref);
	} else {
		maxest = user_maxest;
		minest = user_minest;
	}
	/* Finding the stats for means for reference and sim spikes */
	find_max(maxest,maxwindow,ref,nref,&refmax_mean,&refmax_err);
	find_min(minest,minwindow,ref,nref,&refmin_mean,&refmin_err);
	
	/* initialize assorted variables */
	lastspikeindex=refsteepsamples[0]=refspk[0]=spikeindex=0;
	i = 1;
	temp = (refmax_mean+4.0*refmin_mean)/5.0;

	/* Scan through all spikes, summing the number of points on the
	** spike itself in steepsamples */
	while((spikeindex = find_spike(ref,spikeindex+3,nref,
		maxest,maxwindow))) {
		/* Find the first local min after the spike */
		for (j=spikeindex+1;j<(nref-2);j++){
			min=ref[j];
			if (min<ref[j-1] && min<=ref[j+1] && min<=ref[j+2]) break;
		}
		/* set aside that many points as being too steep */
		if (j<(nref-2))
			refsteepsamples[i]=j-spikeindex;
		else
			break;
		refspk[i]=spikeindex;
		refptp[i]=ref[spikeindex]-min;
		i++;
	}
	refspk[i]=nref-1;
	nrefspk = i+1;

	/* Do it all over again for the sim spikes */
	if (autoest) {
		maxest = est_max(sim,nsim);
		minest = est_min(sim,nsim);
	}
	find_max(maxest,maxwindow,sim,nsim,&simmax_mean,&simmax_err);
	find_min(minest,minwindow,sim,nsim,&simmin_mean,&simmin_err);

	lastspikeindex=simsteepsamples[0]=simspk[0]=spikeindex=0;
	i = 1;
	temp = (simmax_mean+4.0*simmin_mean)/5.0;
	while((spikeindex = find_spike(sim,spikeindex+2,nsim,
		maxest,maxwindow)) && i < nrefspk) {
		/* Find the first local min after the spike */
		for (j=spikeindex+1;j<(nsim-2);j++){
			min=sim[j];
			if (min<sim[j-1] && min<=sim[j+1] && min<=sim[j+2]) break;
		}
		/* set aside that many points as being too steep */
		if (j<(nsim-2))
			simsteepsamples[i]=j-spikeindex;
		else
			break;
		simspk[i]=spikeindex;
		simptp[i]=sim[spikeindex]-min;
		i++;
	}
	simspk[i]=nsim-1;
	nsimspk = i+1;
	/*
	** Check if the spikes are too close to each other to handle
	** There should be at least MIN_SHAPE_SAMPLES samples left over
	** for the shape comparison. 
	*/
	j=0;
	for(i=1;i<nsimspk;i++) {
		if (simspk[i]-simspk[i-1]<simsteepsamples[i]+MIN_SHAPE_SAMPLES){
			badspk[i-1]=1;
			/*
			if (IsSilent() < 2 && j==0) {
				printf (
					"Error in Curvematch: spike interval too small\n");

				j++
			}
			*/
			nbadspk++;
		}
	}

	sum[SNSIMSPK]=nsimspk;
	sum[SNREFSPK]=nrefspk;
	/* Take the smaller number of spikes */
	if (nrefspk > nsimspk)
		nrefspk = nsimspk;

	/* This is the loop where all the stats are calculated */
	for (i = 1 ; i < nrefspk;i++) {
		/* Locate the interspike region, starting at point 0 */
		if (badspk[i-1]) continue;
		start = refspk[i-1]+refsteepsamples[i-1];
		end = refspk[i]-refsteepsamples[i];
		lo = simspk[i-1]+simsteepsamples[i-1];
		hi = simspk[i]-simsteepsamples[i];
		/* Avoid any errors due to missing points */
		if (start>=end || lo>=hi || lo<0 || hi<0 || start<0 || end<0) {
			if (IsSilent() < 2)
				printf (
					"Error in Curvematch: spike does not repolarize\n");
			if (i>1) { /* we have had at least one spike go OK */
				/* Factor in the error due to the truncated trace */
				/* Count up the spikes that were missed out */
				nbadspk+=nrefspk-i;
				break;
			} else { /* This one gave us no useful info at all */
				return;
			}
		}
		/* find scale factor for interspike region */
		reflo = reft[start];
		simlo = simt[lo];
		refspkwidth = reft[end]-reflo;
		simspkwidth = simt[hi]-simlo;
		if (simspkwidth>0.0 && refspkwidth>0.0) {
			temp=refspkwidth/simspkwidth;
			temp=1.0 - 1.0/(temp+1.0/temp-1.0);
			/* temp+=1.0/temp - 2.0; */
			sumsq[SX]+=temp*temp;
			sum[SX]+=temp;
		}

		max = min=ref[start];
		for (j=start;j<=end;j++) {
			if (min > ref[j]) {
				min = ref[j];
			} else if (max < ref[j]) {
				max = ref[j];
			}
		}
		refmin = min;
		refmax=max;
		temp = max - min;
		max = min=sim[lo];
		for (j=lo;j<=hi;j++) {
			if (min > sim[j]) {
				min = sim[j];
			} else if (max < sim[j]) {
				max = sim[j];
			}
		}

		temp=refmin-min;
		if (temp>0) { /* looking for too-low mins */
			sumsq[SL2]+=temp*temp;
			sum[SL2]+=temp;
		}
		sumsq[SL]+=temp*temp;
		sum[SL]+=fabs(temp);

		temp=sim[simspk[i]]-ref[refspk[i]];
		if (temp>0){
			sumsq[SH2]+=temp*temp;
			sum[SH2]+=temp;
		}
		sumsq[SH]+=temp*temp;
		sum[SH]+=fabs(temp);

		/* Note : This one misses out the first and last spike */
		temp=sim[simspk[i-1]]-min-ref[refspk[i-1]]+refmin;
		if (temp<0){ /* looking for too-small ptps */
			temp=-temp;
			sumsq[SP2]+=temp*temp;
			sum[SP2]+=temp;
		}
		sumsq[SP]+=temp*temp;
		sum[SP]+=temp;

		temp=reft[refspk[i]]-simt[simspk[i]];
		sumsq[ST]+=temp*temp;
		sum[ST]+=fabs(temp);

		/*
		temp=fabs((float)(refsteepsamples-simsteepsamples));
		*/
		temp=fabs(simt[simspk[i]+simsteepsamples[i]]-
		simt[simspk[i]-simsteepsamples[i]]-
		reft[refspk[i]+refsteepsamples[i]]+
		reft[refspk[i]-refsteepsamples[i]]);
		sumsq[SW]+=temp*temp;
		sum[SW]+=temp;

		if (max<=min)
			temp = 1.0;
		else {
			temp = (refmax-refmin)/(max - min);
			temp=1.0 - 1.0/(temp+1.0/temp-1.0);
		}
		sumsq[SY]+=temp*temp;
		sum[SY]+=temp;
		for (j=lo;j<=hi;j++) {
			/* we scale x and y for this pt on the sim plot to
			** the equivalent on the ref plot
			*/
			x = reflo + refspkwidth * (simt[j]-simlo)/simspkwidth;
			if (x>reft[end]) {
				if (IsSilent() < 2)
				printf("Error : interpolating outside ref waveform\n");
				break;
			}
			/*
			y = refmin_mean + (refmax_mean - refmin_mean) *
				(sim[j]-simmin_mean)/(simmax_mean-simmin_mean);
			*/
			y = refmin + temp * (sim[j]-min);

			if (linterp(reft+start,ref+start,end-start,x,&ret)) {
				dy = fabs(y - ret);
				sumsq[SS] += dy * dy;
				sum[SS] += dy;
				npts++;
				if (plot_flag) {
					fprintf(rout,"%f	%f\n",x,ret);
					fprintf(sout,"%f	%f\n",x,y);
				}
			}
		}
	}
	if (npts>1) {
		sumsq[SS]/=(float)npts;
		sum[SS]/=(float)npts;
	} else {
		sumsq[SS]=sum[SS]=0.0;
	}
	if (nrefspk-nbadspk > 0) {
		sumsq[SW]/= (float)(nrefspk-nbadspk);
		sum[SW]/= (float)(nrefspk-nbadspk);
		sumsq[SX]/= (float)(nrefspk-nbadspk);
		sum[SX]/= (float)(nrefspk-nbadspk);
		sumsq[SY]/= (float)(nrefspk-nbadspk);
		sum[SY]/= (float)(nrefspk-nbadspk);
	}
	if (nbadspk > nrefspk/2) {
		if (IsSilent() < 2)
			printf("Warning : Too many bad spikes = %d out of %d\n",
				nbadspk,nrefspk);
	}
	temp=fabs((float)(nbadspk+abs(nsimspk-nrefspk)));
	sumsq[SN]=temp;
	sum[SN]=temp*temp;

	free(refspk);
	free(simspk);
	free(badspk);
	free(refptp);
	free(simptp);
	free(refsteepsamples);
	free(simsteepsamples);
	if (plot_flag) {
		fclose(rout);
		fclose(sout);
	}
}

#ifdef STANDALONE
int find_spike(arr,start,npts,maxest,maxwindow)
	float	*arr;
	int		start;
	int		npts;
	float	maxest;
	float	maxwindow;
{
	int i;
	float hi,lo;
	float y;

	hi=maxest+maxwindow;
	lo=maxest-maxwindow;

	if (start > MAXPTS - 3)
		return(0);

	for (i=start+2;i<(npts - 2);i++) {
		y = arr[i];
		if (y > lo && y < hi) {
			if (y>arr[i-2] && y>arr[i-1] && y>=arr[i+1] && y>=arr[i+2])
				return(i);
		}
	}
	return(0);
}

find_max(est,window,arr,npts,mean,err)
	float est;
	float window;
	float *arr;
	int		npts;
	float *mean;
	float *err;
{
	int i;
	float hi,lo;
	float y;
	float sum=0.0,sumsq=0.0;
	float nsum=0.0;

	hi=est+window;
	lo=est-window;

	for (i=2;i<(npts - 2);i++) {
		y = arr[i];
		if (y > lo && y < hi) {
			if (y>arr[i-2] && y>arr[i-1] && y>arr[i+1] && y>arr[i+2]){
				sum+=y;
				nsum+=1.0;
				sumsq+=y*y;
			}
		}
	}

	*mean = 0.0;
	*err = 0.0;

	if (nsum > 0.5) {
		sumsq=sumsq-sum*sum/nsum;
		if (sumsq>0)
			*err=sqrt(sumsq)/nsum;
		*mean=sum/nsum;
	} else {
		*mean = est;
		*err=0.0;
	}
}

find_min(est,window,arr,npts,mean,err)
	float est;
	float window;
	float *arr;
	int		npts;
	float *mean;
	float *err;
{
	int i;
	float hi,lo;
	float y;
	float sum=0.0,sumsq=0.0;
	float nsum=0.0;

	hi=est+window;
	lo=est-window;

	for (i=2;i<(npts - 2);i++) {
		y = arr[i];
		if (y > lo && y < hi) {
			if (y<arr[i-2] && y<arr[i-1] && y<arr[i+1] && y<arr[i+2]){
				sum+=y;
				nsum+=1.0;
				sumsq+=y*y;
			}
		}
	}

	if (nsum > 0.5) {
		sumsq=sumsq-sum*sum/nsum;
		if (sumsq>0)
			*err=sqrt(sumsq)/nsum;
		*mean=sum/nsum;
	} else {
		*mean = est;
		*err=0.0;
	}
}

float est_max(arr,npts)
	float *arr;
	int		npts;
{
	int i;
	float max;

	if (npts <= 0)
		return(0.0);

	max = arr[0];

	for(i=1;i<npts;i++)
		if (max < arr[i])
			max = arr[i];
	return(max);
}

float est_min(arr,npts)
	float *arr;
	int		npts;
{
	int i;
	float min;

	if (npts <= 0)
		return(0.0);

	min = arr[0];

	for(i=1;i<npts;i++)
		if (min > arr[i])
			min = arr[i];
	return(min);
}

/* linterp does linear interpolatoon */
int linterp(xa,ya,n,x,y)
float *xa,*ya,x,*y;
int n;
{
	int klo,khi,k;
	float h,b,a;

	klo=0;
	/* khi=n-1; */
	khi=n;
	while (khi-klo > 1) {
		k=(khi+klo) >> 1;
		if (xa[k] > x) khi=k;
		else klo=k;
	}
	h=xa[khi]-xa[klo];
	if (h == 0.0) {
		printf("phooo! : Bad XA input to linterp in newmatch\n");
		return(0);
	}
	*y= ya[klo]+ (ya[khi]-ya[klo])*(x-xa[klo])/h;
	return(1);
}

#endif

#undef MAXPTS
#undef MAXSPKS
#undef MIN_SHAPE_SAMPLES

#undef SX
#undef SY
#undef SL
#undef SL2
#undef SH
#undef SH2
#undef SP
#undef SP2
#undef SS
#undef ST
#undef SW
#undef SN
#undef NPARMS

#undef SNSIMSPK
#undef SNREFSPK

#undef NSUM
