//genesis
/**********************************************************************
** This program is part of kinetikit and is
**           copyright (C) 1995-1997 Upinder S. Bhalla.
** It is made available under the terms of the GNU General Public License. 
** See the file COPYRIGHT for the full notice.
**********************************************************************/


/******************************************************************
      Stuff for connecting pools : this is done by the reacs etc
	  except for the case of setting up SUMTOTAL messages between
	  pools, which is done here
******************************************************************/

function pool_to_pool_add_sumtot(srcpool,destpool)
	str srcpool,destpool

	if ({getfield /simcontrol/poolsumtot state} == 1)
		echo connecting {srcpool} to {destpool} for SUMTOTAL
		addmsg {srcpool} {destpool} SUMTOTAL n nInit
		call /edit/draw/tree RESET
	end
end

function pool_to_pool_drop_sumtot(srcpool,destpool)
	str srcpool,destpool

	if ({getfield /simcontrol/poolsumtot state} == 1)
		echo disconnecting {srcpool} from {destpool} for SUMTOTAL
		deletemsg {destpool} 0 -find {srcpool} SUMTOTAL
		call /edit/draw/tree RESET
	end
end

function pool_to_pool_add_consv(srcpool,destpool)
	str srcpool,destpool

	if ({getfield /simcontrol/poolsumtot state} == 0)
		echo connecting {srcpool} to {destpool} for CONSERVE
		addmsg {srcpool} {destpool} CONSERVE n nInit
		call /edit/draw/tree RESET
	end
end

function pool_to_pool_drop_consv(srcpool,destpool)
	str srcpool,destpool

	if ({getfield /simcontrol/poolsumtot state} == 0)
		echo disconnecting {srcpool} from {destpool} for CONSERVE
		deletemsg {destpool} 0 -find {srcpool} CONSERVE
		call /edit/draw/tree RESET
	end
end


/******************************************************************
      Stuff for editing pool
******************************************************************/

/* assumes that the current directory is the same as the poolinfo,
** and that the name is current */
function do_update_poolinfo
	str pool = {getfield /parmedit/pool elmpath}

	setfield /parmedit/pool/path value {getpath {pool} -head}
	setfield /parmedit/pool/name value {getpath {pool} -tail}
    setfield /parmedit/pool/vol value {getfield {pool} vol}
    setfield /parmedit/pool/keepconc state {getfield {pool} keepconc}
    setfield /parmedit/pool/n value {getfield {pool} n}
    setfield /parmedit/pool/nTotal value {getfield {pool} nTotal}
    setfield /parmedit/pool/nInit value {getfield {pool} nInit}
    setfield /parmedit/pool/nRemaining value {getfield {pool} nRemaining}
    setfield /parmedit/pool/Co value {getfield {pool} Co}
    setfield /parmedit/pool/CoTotal value {getfield {pool} CoTotal}
    setfield /parmedit/pool/CoInit value {getfield {pool} CoInit}
    setfield /parmedit/pool/CoRemaining value {getfield {pool} CoRemaining}
	setfield /parmedit/pool/buffer_enable state {({getfield {pool} slave_enable} & 4) != 0}
	setfield /parmedit/pool/notes initialtext {getfield {pool} notes}
    setfield /parmedit/pool/color value {getfield {pool} xtree_fg_req}
end


function set_buffering(state)
	int state

	str pool = {getfield /parmedit/pool elmpath}
	int oldslave_enable = {getfield {pool} slave_enable}

	if (state)
		setfield {pool} slave_enable {oldslave_enable | 4}
	else
		setfield {pool} slave_enable {oldslave_enable & 3}
	end
end


function make_xedit_pool
	create xform /parmedit/pool [{EX},{EY},{EW},415]
	addfield /parmedit/pool elmpath -description "path of pool"
	ce /parmedit/pool
	create xdialog path -wgeom 60% -title "Parent"
	create xdialog name -xgeom 60% -ygeom 0 -wgeom 40% -title "Name" \
		-script "set_item_name <w> <v>"
	create xtoggle keepconc [0,0:name,50%,27] \
		-onlabel "Conc fixed, n changes" \
		-offlabel "n fixed, conc changes" \
		-script "set_field <w> <v>"
	/*
	create xtoggle conserve [0:last,0:name,50%,27] \
		-offlabel "pool-pool msgs are CONSERVE" \
		-onlabel "pool-pool msgs are SUMTOTAL"
	*/
	create xdialog n [0,0:keepconc,50%,30] \
		-script "set_field <w> <v>"
	create xdialog nInit [50%,0:keepconc,50%,30] \
		-script "set_field <w> <v>"
	create xdialog nTotal [0,0:n,50%,30] \
		-script "set_field <w> <v>"
	create xdialog nRemaining [50%,0:n,50%,30] \
		-script "set_field <w> <v>"
	create xdialog Co [0,0:nTotal,50%,30] \
		-script "set_field <w> <v>"
	create xdialog CoInit [50%,0:nTotal,50%,30] \
		-script "set_field <w> <v>"
	create xdialog CoTotal [0,0:Co,50%,30] \
		-script "set_field <w> <v>"
	create xdialog CoRemaining [50%,0:Co,50%,30] \
		-script "set_field <w> <v>"
	create xdialog vol [0,0:CoTotal,50%,30] \
		-script "set_field <w> <v>"
	create xtoggle buffer_enable [0:last,0:CoTotal,50%,30] \
		-script "set_buffering <v>" \
		-onlabel "Buffering ON" \
		-offlabel "Buffering OFF"
	create xdialog color -script "set_item_color <w> <v>"
	create xbutton savenotes -label NOTES [0,0:last,10%,130] \
		-script "save_item_notes <w>" -offbg gray
	create xtext notes [0:last,0:color,90%,130] -editable 1
	create xbutton UPDATE [0%,0:notes,50%,30] \
		-script "do_update_poolinfo"
	create xbutton HIDE [50%,0:notes,50%,30] \
		-script "save_item_notes <w>; xhide /parmedit/pool"
	ce /
end

function edit_pool(pool)
	str pool

	setfield /parmedit/pool elmpath {pool}
	do_update_poolinfo
	xshowontop /parmedit/pool
end


/******************************************************************
      Stuff for initializing pools
******************************************************************/

function nonxpoolproto
	create pool /pool
	setfield /pool \
		Co 0 \
		CoInit 0 \
		CoTotal 1
	addfield /pool notes -description "string for pool notes and refs"
	addfield /pool editfunc -description "func for pool edit"
	addfield /pool xtree_fg_req -description "color for pool icon"
	addfield /pool xtree_textfg_req \
		-description "textcolor for pool icon"
	addfield /pool plotfield -description "field to plot"
	addfield /pool manageclass -description "Class that can manage it"

	addobject kpool /pool \
		-author "Upi Bhalla Mt Sinai March 1994" \
	-description "pool plus a notes field"
	setdefault kpool editfunc "edit_pool"
	setdefault kpool xtree_fg_req "blue"
	setdefault kpool xtree_textfg_req "black"
	setdefault kpool plotfield "Co"
	setdefault kpool manageclass "group"
end

function xpoolproto
	ce /control/lib/tree
	create xshape shape -autoindex \
		-drawmode FillRects \
		-fg blue \
		-coords [-.9,-.5,0][.9,.5,0] \
		-text "pool" \
		-textfont 7x13bold \
		-pixflags v \
		-pixflags c \
		-value "kpool" \
		-script \
		"edit_pool.D"

	copy {el ^} /edit/draw/tree -autoindex
	setfield ^ \
		script "edit_pool.D"
	ce /
end

function init_xpool
    // set up the prototype
	nonxpoolproto
	if (DO_X)
    	xpoolproto

		// Set up the calls to handle dragging pools to pools
		call /edit/draw/tree ADDMSGARROW "/kinetics/##[TYPE=kpool]" \
			"/kinetics/##[TYPE=kpool]" "SUMTOTAL" "kpool" "darkgreen" -1 0 \
			"echo.p dragging <S> to <D> for sumtotal" \
			"pool_to_pool_add_sumtot.p <S> <D>" \
			"pool_to_pool_drop_sumtot.p <S> <D>"

		call /edit/draw/tree ADDMSGARROW "/kinetics/##[TYPE=kpool]" \
			"/kinetics/##[TYPE=kpool]" "CONSERVE" "kpool" "blue" -1 0 \
			"echo.p dragging <S> to <D> for conserve" \
			"pool_to_pool_add_consv.p <S> <D>" \
			"pool_to_pool_drop_consv.p <S> <D>"
	
    	// make the editor for pools
    	make_xedit_pool
	end
	// Set up the dumping fields
	simobjdump kpool CoTotal CoInit Co CoRemaining n nInit nTotal \
		nremaining nMin vol slave_enable keepconc notes \
		xtree_fg_req xtree_textfg_req
end

/******************************************************************/
