//genesis
/**********************************************************************
** This program is part of kinetikit and is
**           copyright (C) 1995-1997 Upinder S. Bhalla.
** It is made available under the terms of the GNU General Public License. 
** See the file COPYRIGHT for the full notice.
**********************************************************************/
// Creates the introductory panel with info about the program and the 
// opening statement.

function a_inform(txt)
	str txt
	setfield /about/inform label {txt}
	xflushevents
end


// We need to use xtextload because the COPYRIGHT file might not be
// in the current directory.
function make_xabout
	create xform /about [10,10,780,760]
	create xtext /about/text [0,0,100%,60:NULL.bottom]
	xtextload /about/text \
"" \
"kinetikit: a GENESIS-XODUS based utility and interface for modeling" \
"	chemical kinetics and signaling pathways." \
"" \
"                Copyright (C) 1995-1997 Upinder S. Bhalla " \
"" \
"" \
"         Statement on Models and Experiments." \
"" \
"    Animal experimentation is fundamental to research in biology. Certain" \
"groups claim that computer models can replace animal experiments. This is" \
"absurd. Computer models would be meaningless if it were not" \
"for the enormous amount of careful research that the scientific" \
"community has carried out on animal subjects over the years. All" \
"aspects of realistic models, from the theory to the parameters to the" \
"design of the interface, are based on experiments. While computer models" \
"can help with understanding and relating existing data, they can, at best," \
"merely provide hints towards discovering hitherto unknown biological facts." \
"I am fully in support of the idea of using models as a supplement" \
"to understanding biological function when combined with laboratory work" \
"or a study course. I will be delighted if such a supplement can lead to more" \
"effective and humane use of animal subjects. However, I flatly disagree" \
"with the philosophy that this, or similar modeling tools, can replace" \
"animal experimentation as a means for extending our knowledge of" \
"biological systems. If these views are offensive to you, I urge you not to" \
"use this program (kinetikit), both because it would be hypocrisy on your part" \
"to use a product of animal experimentation, and because it would go" \
"against my objectives in writing this software." \
"" \
"                      Upinder S. Bhalla." \
"" \
"" \
"This program is free software; you can redistribute it and/or modify it under" \
"the terms of the GNU General Public License as published by the Free Software" \
"Foundation; either version 2 of the License, or (at your option) any later" \
"version. This program is distributed in the hope that it will be useful, but" \
"WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY" \
"or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License" \
"for more details." \
"You should have received a copy of the GNU General Public License along" \
"with this program; if not, write to the Free Software Foundation, Inc.," \
"675 Mass Ave, Cambridge, MA 02139, USA." \
"This copyright notice in its entirety, including the Statement on Models" \
"and Experiments, must be present in every copy of the software, and must" \
"be displayed on startup." \
"" \
"Upinder S. Bhalla may be contacted at bhalla@bbb.caltech.edu" \
"" \
"GENESIS, the GEneral Neural SImulation System is copyrighted as follows:" \
"        Copyright 1988 - 1996, California Institute of Technology" \
"   Some components are copyright by the originating institution and are used" \
"    with the permission of the authors."

	create xlabel /about/inform -label "Loading kinetikit"
	create xbutton /about/Dismiss -script "xhide /about"
end

function text_about
echo 
echo "kinetikit: a GENESIS-XODUS based utility and interface for modeling"
echo "	chemical kinetics and signaling pathways."
echo ""
echo "                Copyright (C) 1995-1997 Upinder S. Bhalla "
echo ""
echo ""
echo "         Statement on Models and Experiments."
echo ""
echo "    Animal experimentation is fundamental to research in biology. Certain"
echo "groups claim that computer models can replace animal experiments. This is"
echo "absurd. Computer models would be meaningless if it were not"
echo "for the enormous amount of careful research that the scientific"
echo "community has carried out on animal subjects over the years. All"
echo "aspects of realistic models, from the theory to the parameters to the"
echo "design of the interface, are based on experiments. While computer models"
echo "can help with understanding and relating existing data, they can, at best,"
echo "merely provide hints towards discovering hitherto unknown biological facts."
echo "I am fully in support of the idea of using models as a supplement"
echo "to understanding biological function when combined with laboratory work"
echo "or a study course. I will be delighted if such a supplement can lead to more"
echo "effective and humane use of animal subjects. However, I flatly disagree"
echo "with the philosophy that this, or similar modeling tools, can replace"
echo "animal experimentation as a means for extending our knowledge of"
echo "biological systems. If these views are offensive to you, I urge you not to"
echo "use this program (kinetikit), both because it would be hypocrisy on your part"
echo "to use a product of animal experimentation, and because it would go"
echo "against my objectives in writing this software."
echo ""
echo "                      Upinder S. Bhalla."
echo ""
echo ""
echo "This program is free software; you can redistribute it and/or modify it under"
echo "the terms of the GNU General Public License as published by the Free Software"
echo "Foundation; either version 2 of the License, or (at your option) any later"
echo "version. This program is distributed in the hope that it will be useful, but"
echo "WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY"
echo "or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License"
echo "for more details."
echo "You should have received a copy of the GNU General Public License along"
echo "with this program; if not, write to the Free Software Foundation, Inc.,"
echo "675 Mass Ave, Cambridge, MA 02139, USA."
echo "This copyright notice in its entirety, including the Statement on Models"
echo "and Experiments, must be present in every copy of the software, and must"
echo "be displayed on startup."
echo ""
echo "Upinder S. Bhalla may be contacted at bhalla@bbb.caltech.edu"
echo ""
echo "GENESIS, the GEneral Neural SImulation System is copyrighted as follows:"
echo "        Copyright 1988 - 1996, California Institute of Technology"
echo "   Some components are copyright by the originating institution and are used"
echo "    with the permission of the authors."
echo ""
end
