/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

#ifndef PARSER_h
#define PARSER_h

/* 
 * parser.h
 * 
 * The header file for the parser/symbolic dynamical system library
 */

#include <stdio.h>

#define PARSER_OK 2
#define PARSER_OUT_OF_MEMORY -2

#define INDEP_VF "time"
#define INDEP_MAP "iter"
#define INDEP_MIN_VF 0.0
#define INDEP_MIN_MAP 0.0
#define INDEP_MAX_VF 100.0
#define INDEP_MAX_MAP 10000.0
#define VAR_IC_VF 0.0
#define VAR_IC_MAP 0.0
#define VAR_MIN_VF -10.0
#define VAR_MIN_MAP -1.0
#define VAR_MAX_VF 10.0
#define VAR_MAX_MAP 1.0
#define PAR_IC_VF 1.0
#define PAR_IC_MAP 1.0
#define PAR_MIN_VF -10.0
#define PAR_MIN_MAP -10.0
#define PAR_MAX_VF 10.0
#define PAR_MAX_MAP 10.0
#define FN_MIN_VF 0.0
#define FN_MIN_MAP -10.0
#define FN_MAX_VF 20.0
#define FN_MAX_MAP 10.0


void *parser_create_ds( void );
int parser_add_string( void* ds, char* str);
int parser_build_ds( void* ds);
int parser_get_n_vars(void* ds);
int parser_get_n_pars( void* ds);
int parser_get_n_aux_fns( void* ds);
int parser_get_n_temps( void* ds);
char *parser_get_var_name( void* ds, int i);
char *parser_get_par_name( void* ds, int i);
char *parser_get_aux_fn_name( void* ds, int i);
char *parser_get_temp_name( void* ds, int i);
int parser_eval( void* ds, double f[], double x[], double p[]);
int parser_eval_aux_fn( void* ds, double f[], double x[], double p[]);
int parser_destroy_ds( void * ds);
int parser_print_ds(FILE* fp, void* ds);
int parser_get_var_ic( void* ds, int n, double* pval);
int parser_get_param_ic( void* ds, int n, double* pval);
int parser_get_var_periodic( void* ds, int n, double* p_low, double* p_high);
int parser_get_var_range( void* ds, int n, double* p_min, double* p_max);
int parser_get_param_range( void* ds, int n, double* p_min, double* p_max);
int parser_get_aux_fn_range( void* ds, int n, double* p_min, double* p_max);
int parser_writeC_ds_def( void* ds, FILE* fp);
int parser_writeC_aux_fn( void* ds, FILE* fp);
int parser_write_ds_def( void* ds, FILE* fp);
int parser_write_aux_fn( void* ds, FILE* fp);
int parser_write_temp( void* ds, FILE* fp);

#endif
/* !PARSER_h */
