
/* This file contains win32 structure definitions */

/* Definition of ICO resource structure */
typedef struct {
	Uint8	bWidth;			/* Width, in pixels, of the image */
	Uint8	bHeight;		/* Height, in pixels, of the image */
	Uint8	bColorCount;		/* colors in image (0 if >=8bpp) */
	Uint8	bReserved;		/* Reserved ( must be 0) */
	Uint16	wPlanes;		/* Color Planes (??) */
	Uint16	wBitCount;		/* Bits per pixel */
	Uint32	dwBytesInRes;		/* How many bytes in this resource? */
	Uint32	dwImageOffset;		/* Where in the file is this image? */
} ICONDIRENTRY;

/* The Win32 RGBQUAD struct (4 bytes) */
typedef struct {
	Uint8 rgbBlue;
	Uint8 rgbGreen;
	Uint8 rgbRed;
	Uint8 rgbReserved;
} Win32RGB;

/* The Win32 BITMAPINFOHEADER struct (40 bytes) */
typedef struct {
	Uint32 biSize;
	Sint32 biWidth;
	Sint32 biHeight;
	Uint16 biPlanes;
	Uint16 biBitCount;
	Uint32 biCompression;
	Uint32 biSizeImage;
	Sint32 biXPelsPerMeter;
	Sint32 biYPelsPerMeter;
	Uint32 biClrUsed;
	Uint32 biClrImportant;
	/* The BMP palette
	Win32RGB palette[];
	 */
	/* The image pixels
	Uint8 pixels[]
	 */
	/* The image mask (for icons and cursors)
	Uint8 mask[]
	 */
} Win32BMP;

