#include "global.h"

/*
 * Gdk::Window
 */

VALUE gdkWindow;

static VALUE
gdkwin_get_size(self)
    VALUE self;
{
    int width, height;
    gdk_window_get_size(get_gdkwindow(self), &width, &height);
    return rb_assoc_new(INT2NUM(width), INT2NUM(height));
}

static VALUE
gdkwin_get_pointer(self)
    VALUE self;
{
    int x, y;
    GdkModifierType state;
    gdk_window_get_pointer(get_gdkwindow(self), &x, &y, &state);
    return rb_ary_new3(3, INT2FIX(x), INT2FIX(y), INT2FIX((int)state));

}

static VALUE
gdkwin_pointer_grab(self, owner_events, event_mask, confine_to, cursor, time)
    VALUE self, owner_events, event_mask, confine_to, cursor, time;
{
    gdk_pointer_grab(get_gdkwindow(self),
		     RTEST(owner_events),
		     NUM2INT(event_mask),
		     NULL,  /*get_gdkwindow(confine_to),*/
		     NULL,  /*get_gdkcursor(cursor),*/
		     NUM2INT(time));
    return self;
}

static VALUE
gdkwin_pointer_ungrab(self, time)
    VALUE self, time;
{
    gdk_pointer_ungrab(NUM2INT(time));
    return self;
}

static VALUE
gdkwin_foreign_new(self, anid)
    VALUE self, anid;
{
    GdkWindow *window;
    window = gdk_window_foreign_new(NUM2INT(anid));
    return make_gdkwindow(window);
}

static VALUE
gdkwin_root_window(self)
    VALUE self;
{
    return INT2NUM(GDK_ROOT_WINDOW());
}

static VALUE
gdkwin_clear(self)
    VALUE self;
{
    gdk_window_clear(get_gdkwindow(self));
    return self;
}

static VALUE
gdkwin_clear_area(self, x,y,w,h)
    VALUE self,x,y,w,h;
{
    gdk_window_clear_area(get_gdkwindow(self),
			  NUM2INT(x), NUM2INT(y), NUM2INT(w), NUM2INT(h));
    return self;
}

static VALUE
gdkwin_clear_area_e(self, x,y,w,h)
    VALUE self,x,y,w,h;
{
    gdk_window_clear_area_e(get_gdkwindow(self),
			    NUM2INT(x), NUM2INT(y), NUM2INT(w), NUM2INT(h));
    return self;
}

static VALUE
gdkwin_set_background(self, color)
    VALUE self, color;
{
    gdk_window_set_background(get_gdkwindow(self), get_gdkcolor(color));
    return self;
}

static VALUE
gdkwin_set_back_pixmap(self, pixmap, parent_relative)
    VALUE self, pixmap, parent_relative;
{
    gdk_window_set_back_pixmap(get_gdkwindow(self), get_gdkpixmap(pixmap),
			       RTEST(parent_relative));
    return self;
}

static VALUE
gdkwin_move(self, x,y)
    VALUE self, x,y;
{
    gdk_window_move(get_gdkwindow(self),
		    NUM2INT(x), NUM2INT(y));
    return self;
}

static VALUE
gdkwin_raise(self)
    VALUE self;
{
    gdk_window_raise(get_gdkwindow(self));
    return self;
}

static VALUE
gdkwin_lower(self)
    VALUE self;
{
    gdk_window_lower(get_gdkwindow(self));
    return self;
}

static VALUE
gdkwin_resize(self, w,h)
    VALUE self, w,h;
{
    gdk_window_resize(get_gdkwindow(self),
		      NUM2INT(w), NUM2INT(h));
    return self;
}

static VALUE
gdkwin_move_resize(self, x,y,w,h)
    VALUE self, x,y,w,h;
{
    gdk_window_move_resize(get_gdkwindow(self),
			   NUM2INT(x), NUM2INT(y), NUM2INT(w), NUM2INT(h));
    return self;
}

static VALUE
gdkwin_set_icon(self, icon, pixmap, mask)
    VALUE self, icon, pixmap, mask;
{
    gdk_window_set_icon(get_gdkwindow(self), get_gdkwindow(icon),
			get_gdkpixmap(pixmap), get_gdkbitmap(mask));
    return self;
}

static VALUE
gdkwin_set_icon_name(self, name)
    VALUE self, name;
{
    gdk_window_set_icon_name(get_gdkwindow(self), STR2CSTR(name));
    return self;
}

static VALUE
gdkwin_set_decorations(self, decor)
    VALUE self, decor;
{
    gdk_window_set_decorations(get_gdkwindow(self), NUM2INT(decor));
    return self;
}

static VALUE
gdkwin_set_functions(self, func)
    VALUE self, func;
{
    gdk_window_set_functions(get_gdkwindow(self), NUM2INT(func));
    return self;
}

static VALUE
gdkwin_get_root_origin(self)
    VALUE self;
{
    int x, y;
    gdk_window_get_root_origin(get_gdkwindow(self), &x, &y);
    return rb_assoc_new(INT2FIX(x), INT2FIX(y));
}

static VALUE
gdkwin_get_events(self)
    VALUE self;
{
    return INT2NUM(gdk_window_get_events(get_gdkwindow(self)));
}

static VALUE
gdkwin_set_events(self, mask)
    VALUE self, mask;
{
    gdk_window_set_events(get_gdkwindow(self), NUM2INT(mask));
    return self;
}

static VALUE
gdkwin_reparent(self, new_parent, x, y)
    VALUE self, new_parent, x, y;
{
    gdk_window_reparent(get_gdkwindow(self), get_gdkwindow(new_parent),
			NUM2INT(x), NUM2INT(y));
    return self;
}


/*
 * Gdk::WindowAttr
 */

VALUE gdkWindowAttr;


void
Init_gtk_gdk_window()
{
    /* Gdk::Window */

    gdkWindow = rb_define_class_under(mGdk, "Window", gdkDrawable);

    rb_define_method(gdkWindow, "get_size", gdkwin_get_size, 0);
    rb_define_method(gdkWindow, "get_pointer", gdkwin_get_pointer, 0);
    rb_define_method(gdkWindow, "pointer_grab", gdkwin_pointer_grab, 5);
    rb_define_method(gdkWindow, "pointer_ungrab", gdkwin_pointer_ungrab, 1);
    rb_define_singleton_method(gdkWindow, "foreign_new", gdkwin_foreign_new, 1);
    rb_define_singleton_method(gdkWindow, "root_window", gdkwin_root_window, 0);
    rb_define_method(gdkWindow, "clear", gdkwin_clear, 0);
    rb_define_method(gdkWindow, "clear_area", gdkwin_clear_area, 4);
    rb_define_method(gdkWindow, "clear_area_e", gdkwin_clear_area_e, 4);
    rb_define_method(gdkWindow, "set_background", gdkwin_set_background, 1);
    rb_define_method(gdkWindow, "set_back_pixmap", gdkwin_set_back_pixmap, 2);
    rb_define_method(gdkWindow, "move", gdkwin_move, 2);
    rb_define_method(gdkWindow, "raise", gdkwin_raise, 0);
    rb_define_method(gdkWindow, "lower", gdkwin_lower, 0);
    rb_define_method(gdkWindow, "resize", gdkwin_resize, 2);
    rb_define_method(gdkWindow, "move_resize", gdkwin_move_resize, 4);
    rb_define_method(gdkWindow, "set_icon", gdkwin_set_icon, 3);
    rb_define_method(gdkWindow, "set_icon_name", gdkwin_set_icon_name, 1);
    rb_define_method(gdkWindow, "set_decorations", gdkwin_set_decorations, 1);
    rb_define_method(gdkWindow, "set_functions", gdkwin_set_functions, 1);
    rb_define_method(gdkWindow, "get_root_origin", gdkwin_get_root_origin, 0);
    rb_define_method(gdkWindow, "get_events", gdkwin_get_events, 0);
    rb_define_method(gdkWindow, "set_events", gdkwin_set_events, 1);
    rb_define_method(gdkWindow, "reparent", gdkwin_reparent, 3);

    /* Gdk::WindowAttr */

    gdkWindowAttr = rb_define_class_under(mGdk, "WindowAttr", rb_cData);
}
