/*****************************************************************************
 *                                                                           *
 * Widget:    gtkimmov                                                       *
 * Uses:      GTK+1.2, GdkImlib                                              *
 * Purpose:   Cut images at coordites this way, that they match each other.  *
 *            The matching can be controlled via certain view modes          *
 * Author:    Andreas Tille <tillea@rki.de>                                  *
 * Date:      May 03, 1999                                                   *
 * Copyright: Andreas Tille, 1998, 1999                                      *
 * License:   LGPL                                                           *
 *                                                                           *
 *****************************************************************************/

#ifndef __GTK_IMMOV_H__
#define __GTK_IMMOV_H__

#include <gtk/gtkwindow.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define GTK_TYPE_IMMOV            (gtk_immov_get_type ())
#define GTK_IMMOV(obj)            (GTK_CHECK_CAST ((obj), GTK_TYPE_IMMOV, GtkImMov))
#define GTK_IMMOV_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_IMMOV, GtkImMovClass))
#define GTK_IS_IMMOV(obj)         (GTK_CHECK_TYPE ((obj), GTK_TYPE_IMMOV))
#define GTK_IS_IMMOV_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_IMMOV))

typedef struct _GtkImMov          GtkImMov;
typedef struct _GtkImMovClass     GtkImMovClass;

typedef struct _GtkImMovPic       GtkImMovPic;
typedef gint  (*GtkImMovShowFunc)(GtkWidget *immov);

struct _GtkImMovPic
{
  gint    width;      /* width of image                                            */
  gint    height;     /* height of image                                           */
  gint    xo;         /* vertical offset according to fix image                    */
  gint    yo;         /* horizontal offset according to fix image                  */
  gint    x1;         /* left position to cut                                      */
  gint    y1;         /* top position to cut                                       */   
  gint    x2;         /* right position to cut                                     */
  gint    y2;         /* bottom position to cut                                    */   
  guchar *data;       /* RGB data                                                  */
  gchar  *id;         /* string to identify the image (usual its source file name) */
  gchar   free;       /* flag, if memory has to be freed or not                    */
};

struct _GtkImMov
{
  GtkWindow        window;

  GtkWidget       *main_vbox;
  GtkWidget       *nb;      /* notebook containing all moving images            */
  GtkWidget       *draw;    /* drawable to show pixmap                          */
  GdkPixmap       *pm;      /* Backing pixmap for drawing area                  */
  GtkWidget       *ok_button;
  GtkWidget       *cancel_button;
  GtkWidget       *parms;   /* hbox with parameters                             */
  GtkAdjustment   *vert, *hori;
   /*  gint             curvert, curhori; */
  gint             maxvert, maxhori;
  GtkImMovPic     *fix;     /* fix reference image for all other images         */
  GtkImMovPic     *cur;     /* currently processed image                        */
  GtkImMovPic     *im;      /* moving image showing movement of cur against fix */ 
  GList           *iml;     /* GList of images to move                          */
  GtkImMovShowFunc show;    /* function to visualize the moved images           */
};

struct _GtkImMovClass
{
  GtkWindowClass parent_class;
};


GtkType      gtk_immov_get_type         (void);
GtkWidget*   gtk_immov_new              (const gchar *title, GtkImMovPic *fix, GList *movl, gint automatch);
void         gtk_immov_free_struct      (GtkImMovPic *pic);
GtkImMovPic* gtk_immov_copy_struct      (gint width, gint height, guchar *data, gchar *id);
GtkImMovPic* gtk_immov_set_struct       (gint width, gint height, guchar *data, gchar *id);
gint         gtk_immov_automatch        (GtkWidget *button, GtkImMov *immov);
/* The following functions could be called without initalizing GTK */
void         immov_automatch            (GList *l, GtkImMovPic *fix);
gint         immov_accept_images        (GList *list, GtkImMovPic *fix);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GTK_IMMOV_H__ */

