/*$Id: u_prblst.h,v 14.10 1999/07/06 07:32:12 al Exp $ -*- C++ -*-
 * list of probes
 */
#ifndef U_PRBLST_H
#define U_PRBLST_H
#include "mode.h"
#include "u_probe.h"
/*--------------------------------------------------------------------------*/
class CS;
class CKT_BASE;
/*--------------------------------------------------------------------------*/
class PROBELIST {
private:
  typedef std::vector<PROBE> container;
  container bag;
public:
  typedef container::iterator	    iterator;
  typedef container::const_iterator const_iterator;
  void	   list(const std::string&)const;
  void     clear();
  void	   operator-=(CS&);
  void     operator-=(CKT_BASE*);
  void     operator+=(CS&);
  int	   size()const	{return bag.size();}
  iterator begin()	{return bag.begin();}
  iterator end()	{return bag.end();}
private:
  void     add_node_list(CS&,const std::string&);
  void     add_branches(CS&,const std::string&);
  void     add_all_nodes(const std::string&);
};
/*--------------------------------------------------------------------------*/
class PROBE_LISTS {
public:
 static PROBELIST alarm[sCOUNT]; // list of alarm probes
 static PROBELIST plot[sCOUNT];  // list of plot probes
 static PROBELIST print[sCOUNT]; // list of print probes
 static PROBELIST store[sCOUNT]; // list of probes to store for postproc
 static void purge(CKT_BASE*);
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
