/*$Id: main.cc,v 15.18 1999/10/30 08:04:59 al Exp $ -*- C++ -*-
 * top level module
 * it all starts here
 */
#include "patchlev.h"
#include "c_comand.h"
#include "declare.h"	/* lots */
#include "u_opt.h"
#include "l_jmpbuf.h"
/*--------------------------------------------------------------------------*/
	int	main(int,const char*[]);
static	void    sign_on(void);
static	void    read_startup_files(void);
static	void    process_cmd_line(int,const char*[]);
static	void	finish(void);
/*--------------------------------------------------------------------------*/
extern JMP_BUF env;
/*--------------------------------------------------------------------------*/
int main(int argc, const char *argv[])
{
  {
    SET_RUN_MODE xx(rBATCH);
    initialize_io();
    sign_on();
    if (!sigsetjmp(env.p, true)){
      //try {
      read_startup_files();
      setup_traps();
      process_cmd_line(argc,argv);
    }else{
      //}catch (...){
      finish();		/* error clean up (from longjmp())	*/
      exit(0);
    }
  }
  for (;;){
    SET_RUN_MODE xx(rINTERACTIVE);
    if (!sigsetjmp(env.p, true)){
      //try {
      char cmdbuf[BUFLEN];
      CMD::count++;
      getcmd("-->", cmdbuf, BUFLEN);
      CMD::cmdproc(cmdbuf);
    }else{
      //}catch (...){
      finish();		/* error clean up (from longjmp())	*/
    }  
  }
  return 0;
}
/*--------------------------------------------------------------------------*/
static void sign_on(void)
{
  IO::mstdout << "ACS (Al's Circuit Simulator) 0." << PATCHLEVEL << '\n'
    << "Never trust any version less than 1.0\n"
    << "Copyright 1994, Albert Davis\n"
    << "ACS comes with ABSOLUTELY NO WARRANTY\n"
    << "This is free software, and you are welcome\n"
    << "to redistribute it under certain conditions.\n"
    << "See the file \"COPYING\" for details\n";
}
/*--------------------------------------------------------------------------*/
static void read_startup_files(void)
{
  std::string name = findfile(SYSTEMSTARTFILE, SYSTEMSTARTPATH, R_OK);
  if (!name.empty()){
    char cmdbuf[BUFLEN];
    sprintf(cmdbuf, "get %s", name.c_str());
    CMD::cmdproc(cmdbuf);
  }
  name = findfile(USERSTARTFILE, USERSTARTPATH, R_OK);
  if (!name.empty()){
    char cmdbuf[BUFLEN];
    sprintf(cmdbuf, "get %s", name.c_str());
    CMD::cmdproc(cmdbuf);
  }
  CMD::cmdproc("clear");
}
/*--------------------------------------------------------------------------*/
static void process_cmd_line(int argc, const char *argv[])
{
  if (argc > 1){
    char cmdbuf[BUFLEN];
    sprintf(cmdbuf, "< %s", argv[1]);
    CMD::cmdproc(cmdbuf);
  }
}
/*--------------------------------------------------------------------------*/
/* finish: clean up after a command
 * deallocates space, closes plot windows, resets i/o redirection, etc.
 * This is done separately for exception handling.
 * If a command aborts, clean-up is still done, leaving a consistent state.
 */
static void finish(void)
{
  plclose();
  IO::suppresserrors = false;
  outreset();
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
