/*$Id: l_compar.h,v 14.18 1999/08/16 02:43:02 al Exp $ -*- C++ -*-
 * inline utility functions, general purpose
 */
#ifndef L_UTIL_H
#define L_UTIL_H
#include "md.h"
/*--------------------------------------------------------------------------*/
/* uporder: returns true if a,b,c are in non-decreasing order */
inline bool uporder(double a, double b, double c)
   {return (a<=b) && (b<=c);}

/* inorder: returns true if b is between a and c */
inline bool inorder(double a, double b, double c)
   {return uporder(a,b,c) || uporder(c,b,a);}

/* torange: returns b, clipped to range a..c */
inline double torange(double a, double b, double c)
   {return std::min(std::max(a,b),c);}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
