/*$Id: e_base.h,v 14.13 1999/08/01 03:34:53 al Exp $ -*- C++ -*-
 * real base for anything to do with a circuit
 */
#ifndef E_BASE_H
#define E_BASE_H
#include "md.h"
#include "m_matrix.h"
/*--------------------------------------------------------------------------*/
class XPROBE;
/*--------------------------------------------------------------------------*/
class CKT_BASE {
private:
  static int _devcount;
  int	     _probes;		/* number of probes set */
protected:
  explicit CKT_BASE()			: _probes(0) {++_devcount;}
  explicit CKT_BASE(const CKT_BASE&)	: _probes(0) {++_devcount;}
  virtual  ~CKT_BASE();
public:
  static  BSMATRIX<double>  aa;	/* raw matrix for DC & tran */
  static  BSMATRIX<double>  lu;	/* decomposed matrix for DC & tran */
  static  BSMATRIX<COMPLEX> acx;/* raw & decomposed matrix for AC */
public:
  virtual const std::string long_label()const {unreachable(); return "";}
  virtual double      probe_num(const std::string&)const;
  virtual double      probe_tr_num(const std::string&)const;
  virtual double      probe_ac_num(const std::string&)const;
  virtual XPROBE      probe_ac_ext(const std::string&)const;
	  void	      inc_probes()	{++_probes;}
	  void	      dec_probes()	{assert(_probes>0); --_probes;}
	  bool	      has_probes()const	{return _probes > 0;}
  static  int	      device_count()	{return _devcount;}
};
/*--------------------------------------------------------------------------*/
inline bool exists(const CKT_BASE* c) {return c!=0;}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
