/*$Id: d_mos2.h,v 14.19 1999/08/18 17:17:11 al Exp $ -*- C++ -*-
 * MOS model - Spice level 2
 */
#ifndef D_MOS2_H
#define D_MOS2_H
#include "d_mos123.h"
/*--------------------------------------------------------------------------*/
class MODEL_MOS2 : public MODEL_MOS123 {
private:
  explicit	MODEL_MOS2(const MODEL_MOS2& p):MODEL_MOS123(p){unreachable();}
  void		parse_params(CS&);
  void		post_parse();
public:
  explicit	MODEL_MOS2();
private: // override virtual
  void		print(OMSTREAM,int)const;
  void		tr_eval(COMPONENT*)const;  
private:		/* strictly internal */
  enum {LEVEL=2};
public:			/* input parameters */
  double   nfs;		/* -23--- fast surface state density */
  double   vmax;	/* -23--- max drift velocity of carriers */
  double   neff;	/* -2---- total channel charge coefficient */
  double   ucrit;	/* ----c- critical field mobility degradation */
  double   uexp;	/* -2---- critical field exponent in mob.deg. (mos2) */
  double   utra;	/* ------ transverse field coefficient (not used) */
private:		/* calculated parameters */
  double   xd;		/* -23-c- sqrt(alpha) */
  double   xwb;		/* -2--c- xd * sqrt(pb) */
  double   vbp;		/* -2---- ucrit * E_SI / cox (mos2) */
  double   cfsox;	/* -23--- Q * nfs / cox */
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
