/*$Id: d_cccs.cc,v 15.19 1999/11/03 18:07:50 al Exp $ -*- C++ -*-
 * functions for cccs
 * It is really voltage controlled, taking into account the sense element.
 * Then adjust the gain to account for the sense element.
 */
#include "d_cccs.h"
/*--------------------------------------------------------------------------*/
void DEV_CCCS::precalc()
{
  assert(loss == 0.);
  y0.f0 = LINEAR;
  y0.f1 = value();
  m0.c1 = y0.f1;
  m0.c0 = 0.;
  set_converged();
  assert(!constant()); /* because of incomplete analysis */
}
/*--------------------------------------------------------------------------*/
void DEV_CCCS::dc_begin()
{
  if (!has_tr_eval()){
    assert(y0.f0 == LINEAR);
    assert(y0.f1 == value());
    assert(loss == 0.);
  }
}
/*--------------------------------------------------------------------------*/
bool DEV_CCCS::do_tr()
{
  assert(_input);
  {if (has_tr_eval()){
    m0.x = volts_limited(n[IN1], n[IN2]);
    y0.x = _input->tr_amps();
    tr_eval();
    m0.c0 = y0.f0 - y0.x * y0.f1;
  }else{
    assert(y0.f0 == LINEAR);
    assert(y0.f1 == value());
    m0.c0 = 0.;
    assert(converged());
  }}
  m0.c0 += y0.f1 * _input->m0.c0;
  m0.c1  = y0.f1 * (_input->loss + _input->m0.c1);
  store_values();
  q_load();
  return converged();
}
/*--------------------------------------------------------------------------*/
void DEV_CCCS::do_ac()
{
  assert(_input);
  if (!_input->evaluated()){	/* patch for forward reference */
    _input->do_ac();		/* make sure sense elt is evaluated first */
  }
  {if (has_ac_eval()){
    ac_eval();
  }else{
    assert(ev == y0.f1);
    assert(has_tr_eval() || ev == value());
  }}
  {if (_input->is_source()){	/* if the sense elt is a fixed source.. */
    acg = ev * _input->acg;	/* then part of this one can be modeled */
    ac_load_source();		/* as a fixed source. ...		*/
    acg = ev * _input->loss;	/* so load it in 2 pieces		*/
  }else{
    acg = ev * _input->acg;
  }}
  ac_load_active();
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
