/*$Id: bm_pulse.cc,v 15.19 1999/11/03 18:07:50 al Exp $ -*- C++ -*-
 * SPICE compatible PULSE
 */
#include "ap.h"
#include "bm.h"
/*--------------------------------------------------------------------------*/
//		EVAL_BM_PULSE::EVAL_BM_PULSE(int c);
//		EVAL_BM_PULSE::EVAL_BM_PULSE(const EVAL_BM_PULSE&);
//	void	EVAL_BM_PULSE::parse(CS& cmd);
// 	void	EVAL_BM_PULSE::print(int)const;
//	void	EVAL_BM_PULSE::tr_eval(COMPONENT* d)const;
/*--------------------------------------------------------------------------*/
const double _default_iv    (NOT_INPUT);
const double _default_pv    (NOT_INPUT);
const double _default_delay (0);
const double _default_rise  (0);
const double _default_fall  (0);
const double _default_width (BIGBIG);
const double _default_period(BIGBIG);
/*--------------------------------------------------------------------------*/
EVAL_BM_PULSE::EVAL_BM_PULSE(int c)
  :EVAL_BM_ACTION_BASE(c),
   _iv(_default_iv),
   _pv(_default_pv),
   _delay(_default_delay),
   _rise(_default_rise),
   _fall(_default_fall),
   _width(_default_width),
   _period(_default_period),
   _end(NOT_VALID)
{
}
/*--------------------------------------------------------------------------*/
EVAL_BM_PULSE::EVAL_BM_PULSE(const EVAL_BM_PULSE& p)
  :EVAL_BM_ACTION_BASE(p),
   _iv(p._iv),
   _pv(p._pv),
   _delay(p._delay),
   _rise(p._rise),
   _fall(p._fall),
   _width(p._width),
   _period(p._period),
   _end(NOT_VALID)
{
  untested();
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_PULSE::parse(CS& cmd)
{
  cmd.stuck();
  do{
    int paren = cmd.skiplparen();
    double* i;
    for (i = &_iv;  i < &_end;  ++i){
      double value=NOT_VALID;
      cmd >> value;
      if (cmd.stuck()){
	break;
      }
      *i = value;
    }
    assert(i <= &_end);
    paren -= cmd.skiprparen();
    if (paren != 0){
      untested();
      cmd.warn(bWARNING, "need )");
    }
    cmd.get("IV",	&_iv);
    cmd.get("PV",	&_pv);
    cmd.get("DELAY",	&_delay);
    cmd.get("RISE",	&_rise);
    cmd.get("FALL",	&_fall);
    cmd.get("WIDTH",	&_width);
    cmd.get("PERIOD",	&_period);
    parse_base(cmd);
  }while (cmd.more() && !cmd.stuck());
  parse_base_finish();
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_PULSE::print(OMSTREAM where)const
{
  where << "  " << name()
	<< "  iv="	<< _iv
	<< "  pv="	<< _pv
	<< "  delay="	<< _delay
	<< "  rise="	<< _rise
	<< "  fall="	<< _fall
	<< "  width="	<< _width
	<< "  period="	<< _period;
  print_base(where);
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_PULSE::tr_eval(COMPONENT* d)const
{
  double time = SIM::time0;
  if (0 < _period && _period < BIGBIG){
    time = fmod(time,_period);
  }
  
  double ev = 0; // effective value
  {if (time > _delay+_rise+_width+_fall){	/* past pulse	*/
    ev = _iv;
  }else if (time > _delay+_rise+_width){	/* falling 	*/
    double interp = (time - (_delay+_rise+_width)) / _fall;
    ev = _pv + interp * (_iv - _pv);
  }else if (time > _delay+_rise){		/* pulse val 	*/
    ev = _pv;
  }else if (time > _delay){			/* rising 	*/
    double interp = (time - _delay) / _rise;
    ev = _iv + interp * (_pv - _iv);
  }else{					/* init val	*/
    ev = _iv;
  }}

  tr_finish_tdv(d, ev);
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
