/*$Id: ap_ctos.cc,v 14.10 1999/07/06 07:32:12 al Exp $ -*- C++ -*-
 * get string from string
 */
#include "ap.h"
/*--------------------------------------------------------------------------*/
//	void	CS::ctostr(char* d, int l, const std::string& t);
//  std::string CS::ctos(const std::string& term);
/*--------------------------------------------------------------------------*/
/* ctostr: character input to string
 * scan (and eat) an input string (cmd) using index (cnt).
 * result in (des)  (null terminated).
 * max length (actual char count) is (len).
 * (des) must be at least (len)+1 characters long.
 * (cmd) unchanged.  (*cnt) updated to point to next argument.
 * skips leading whitespace.  skips trailing whitespace and comma
 * skips parts of input word too big for destination
 */
void CS::ctostr(char* des, int len, const std::string& term)
{
  skipbl();
  int ii;
  for (ii = 0;  ii < len && !is_term(term);  ii++){
    des[ii] = ctoc();
  }
  des[ii] = '\0';

  while (!is_term(term))
    skip();
  skipcom();
}
/*--------------------------------------------------------------------------*/
std::string CS::ctos(const std::string& term)
{
  std::string des;
  skipbl();
  while (!is_term(term)){
    des += ctoc();
  }
  skipcom();
  return des;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
