.TH MD 1 "09 March 1999"
.SH NAME
md, mds, mm\- Memory manipulation commands
.SH SYNOPSIS
md [ \fIaddress-expression\fP [ \fIline-count\fP [\fIoutput-radix\fP ] ] ]
.LP
mds [ \fIaddress-expression\fP [ \fIline-count\fP [\fIoutput-radix\fP ] ] ]
.LP
mm \fIaddress-expression\fP \fInew-contents\fP
.SH DESCRIPTION
The
.B md 
command is used to display the contents of memory.
The \fIaddress-expression\fP may be a numeric value (decimal or
hexidecimal), a symbol name, a register name preceeded by one or more
percent symbols '%', an environment variable name preceeded by
a currency symbol '$',  or a simple expression consisting of a 
symbol name, an addition or subtraction character and a numeric
value (decimal or hexidecimal).
.P
If the \fIline-count\fP or \fIradix\fP arguments are omitted, 
they default to the values of the \fBMDCOUNT\fP and \fBRADIX\fP 
environment variables respectively.   If the \fBMDCOUNT\fP or 
\fBRADIX\fP environment variables are unset, the appropriate
defaults will be used [see \fBENVIRONMENT\fP below].
.P
The
.B mds
command displays the contents of memory one word per line and
attempts to correlate the contents of each word with a symbol
in the symbol table.   If no symbol is found, the ascii representation
of the word is printed, otherwise the symbol name and offset from
symbol value are printed.
.P
The
.B mm
command allows modification of memory.   The word at the address
represented by \fIaddress-expression\fP is changed to 
\fInew-contents\fP.  \fInew-contents\fP is allowed to be an
\fIaddress-expression\fP.
.SH LIMITATIONS
None.
.SH ENVIRONMENT
.TP 8
MDCOUNT
This environment variable (default=8) defines the number of lines
that will be displayed by each invocation of the \fBmd\fP command.

.TP 8
RADIX
This environment variable (default=16) defines the radix used to
print the memory contents.  

.TP 8
BYTESPERWORD
This environment variable (default=4) selects the width of output
data when printing memory contents.  Select the value two to get
16-bit word output, select the value one to get byte output.

.TP 8
LINES
This environment variable governs the number of lines of output 
that will be presented before the kernel debugger built-in pager
pauses the output.   This variable only affects the functioning
of the \fBmd\fP and \fBmds\fP if the \fBMDCOUNT\fP variable 
is set to a value greater than the \fBLINES\fP variable.
.SH SMP CONSIDERATIONS
None.
.SH EXAMPLES
.TP 8
md %edx
Display memory starting at the address contained in register \fB%edx\fP.

.TP 8
mds %esp
Display stack contents symbolically.   This command is quite useful
in manual stack traceback.

.TP 8
mm 0xc0252110 0x25
Change the memory location at 0xc0252110 to the value 0x25.

.TP 8
md chrdev_table 15
Display 15 lines (at 16 bytes per line) starting at address 
represented by the symbol \fIchrdev_table\fP.
