#ifndef HINTS_H
#define HINTS_H

#include <vector.h>
#include <map>
#include <multimap.h>
#include <iostream.h>
#include <algo.h>
#include <set>
#include "adstring.h"


#define DEBUG  //adding this will add useless code that may slowdown things

#define DEBUGGING(a)    a
#define CDEBUGGING(a)   ,a


extern bool operator< (const set<String> &left,
		const set<String> &right);

extern ostream& operator<<(ostream &, const StrVec &);


class hint_tree;

class correlation;

typedef multimap <double, vector <hint_tree>, less<double> > 
            possible_divisions;
typedef multimap <double, possible_divisions::iterator, less<double> > 
            possible_divisions_it;

class hint_tree{
public:
  String key;
  DEBUGGING(vector<StrVec> entries;)
  double penalty; //of the whole tree (including children, grandchildren, etc).
  vector <hint_tree> children;
  hint_tree(String k, vector <hint_tree> &c){
    key=k;
    children=c;
  };
  hint_tree(String k){
    key=k;
  };
};

class hints {
 private:
  bool debugopt;
  double max_local_penalty;
  hint_tree *tree;
  
  double mixed_penalty;
  double min_hint_freq;
  double hint_nentry, hint_topnentry;
  unsigned int max_ntry;
  int max_iter_hint;
  
  vector <StrVec> hint_list;
  vector <int> raw_count;
 public:
  void set_nentry(double n){hint_nentry=n;};
  void set_topnentry(double n){hint_topnentry=n;};  
  void set_mixedpenalty(double p){mixed_penalty=p;};
  void set_minhintfreq(double m){min_hint_freq=m/hint_nentry;};
  void set_max_local_penalty(double p){max_local_penalty=p;};
  void set_max_ntry(int n){max_ntry=n;};
  void set_max_iter_hint(int n){max_iter_hint=n;};
  void set_debug(bool opt){debugopt=opt;};
  hints();
  void calc_tree(const vector <StrVec> &hint_input,
		       vector <StrVec> &hint_output);
  void debug();
 private:
  void order();
  double sqr(double);
  double calc_penalty(int level, int n, int unused);
  double nopt(int level){
    if(level!=0) 
      return hint_nentry; 
    else 
      return hint_topnentry;
  };
  void add_division(int level, possible_divisions &division_list, 
		    const vector <unsigned int> &division, 
		    correlation &h, 
		    int unused, 
		    double &worst_penalty
		    CDEBUGGING(unsigned int itteration));
  bool try_shortcut(int level,
			const vector <StrVec > &hint_input, 
			const vector <int> &raw_input_count,
			hint_tree &t,
			int already_used);
  void find_possible_divisions(int level, possible_divisions &division_list,
			       const vector <StrVec> &hint_input,
			       const vector <int> &raw_input_count,
			       int already_used);
  void postprocess(int level, 
		   const vector <StrVec> &hint_input, 
		   const vector <int> &raw_input_count,
		   hint_tree &t,
		   int already_used);
  void search_hint(hint_tree &t,
		   const StrVec &hint_in,
		         StrVec &hint_out);
  void debug_hint_tree(const hint_tree &t, int level);
  void nspace(int);

  //next ones should be removed:
  void add_input();

};


#endif /*  HINTS_H */
