/* #Specification: mrtg / mrtg_loadavg utility
	This small utility is used to collect the load average for the mrtg
	grapher. It multiplies the load by 100 to make it acceptable to mrtg.

	mrtg produces two graphs, but the second number is always 0.
*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>

int main (int , char *[])
{
	int ret = -1;
	FILE *fin = fopen ("/proc/loadavg","r");
	if (fin == NULL){
		fprintf (stderr,"Can't open file /proc/loadavg (%s)\n"
			,strerror(errno));
	}else{
		double load5,load10,load15;
		fscanf (fin,"%lf %lf %lf\n",&load5,&load10,&load15);
		fclose (fin);
		printf ("%d\n",(int)(load5*100));
		printf ("0\n");		// No second value for this graph
		fflush (stdout);
		system ("uptime");
		printf ("Load average\n");
		ret = 0;
	}
	return ret;
}

