#ifndef FWINFO_APIDEF_H
#define FWINFO_APIDEF_H

struct FWINFO_API{
	// Tell if one logical device exist (up or not)
	bool (*devexist) (const char *devname);
	// Get the list of all logical devices control by this API
	// The logical devices are added in devs with a description in descs
	int (*getdevlist)  (SSTRINGS &devs, SSTRINGS &descs);
	// Get the real device associated with a logical device
	// Return -1 if the device is not up
	int (*getdevinfo)  (const char *devname, SSTRING &kerneldev);
	// Tell if one logical host exist
	bool (*hostexist) (const char *hostname);
	// Get the list of all logical hosts control by this API
	// The logical hosts are added in devs with a description in descs
	int (*gethostlist)  (SSTRINGS &hosts, SSTRINGS &descs);
	// Get the IP number of the logical host
	// Return -1 if the host is not available
	int (*gethostinfo)  (const char *hostname, SSTRING &host);
};

#endif


