#include <string.h>
#include "modemconf.h"
#include "modemconf.m"
#include <unistd.h>

#define UNKNOWN_DEV 4
#define STR_MAX     256

class MODEM {
	int  dev;	/* device: /dev/ttyS{0,1,2,3} */
	int  irq;	/* not yet ;) */
public:
	MODEM (void);
	int  get_device (void);
	void set_device (int dev);
};

MODEM::MODEM (void)
{
	dev = irq = 0;
}

int MODEM::get_device (void)
{
	char buf[STR_MAX];
	int ret, get_dev;

	dev = UNKNOWN_DEV;

	ret = readlink ("/dev/modem", buf, sizeof buf);
	if (ret != -1) {
		buf[ret] = '\0';
		if (sscanf (buf, "/dev/ttyS%d", &get_dev) ||
		    sscanf (buf, "ttyS%d", &get_dev)      ||
		    sscanf (buf, "/dev/cua%d", &get_dev)  ||
		    sscanf (buf, "cua%d", &get_dev))
			if (get_dev >= 0 && get_dev <= 3)
				dev = get_dev;
	}

	return dev;
}

void MODEM::set_device (int new_dev)
{
	static char new_link[STR_MAX];
	
	dev = new_dev;

	if (dev != UNKNOWN_DEV) {
		unlink ("/dev/modem");
		snprintf (new_link, sizeof(new_link)-1, "/dev/ttyS%d", dev);
		symlink (new_link, "/dev/modem");
	}
}

void modemconf_edit (void)
{
	DIALOG dia;
	MODEM  modem;
	char   dev = modem.get_device ();

	for (int i=0; i < UNKNOWN_DEV+1; i++) {
		char msg[STR_MAX];
		snprintf (msg, sizeof(msg)-1, MSG_U(F_DEVICE, "/dev/ttyS%d (COM%d under DOS)"), i, i+1);
		dia.newf_radio ("", dev, i, i == UNKNOWN_DEV ? MSG_U(F_UNKNOWN, "Unknown") : msg);
	}

	int foo = 0;
	if (dia.edit (MSG_U(T_MODEMCONF, "Modem Configurator"),
		      MSG_U(I_MODEMCONF, "Select the port to which your modem is connected.\n"
                                         "If you have no modem, select <Unknown>"), help_nil, foo) == MENU_ACCEPT)
		if (perm_rootaccess (MSG_U(P_SELDEV,"Select the modem device"))){
			modem.set_device (dev);
		}
}
