#include "misc.h"

PUBLIC SSTRING *SSTRINGS::getitem (int no) const
{
	return (SSTRING *)ARRAY::getitem(no);
}

static int cmp (const ARRAY_OBJ *o1, const ARRAY_OBJ *o2)
{
	SSTRING *s1 = (SSTRING *)o1;
	SSTRING *s2 = (SSTRING *)o2;
	return s1->cmp(*s2);
}

/*
	Sort the array of SSTRING
*/
PUBLIC void SSTRINGS::sort ()
{
	ARRAY::sort (cmp);
}


/*
	Find the occurence of a string in the array.
	Return -1 if not found or the index if found
*/
PUBLIC int SSTRINGS::lookup(const char *str) const
{
	int ret = -1;
	int nb = getnb();
	for (int i=0; i<nb; i++){
		SSTRING *s = getitem(i);
		if (s->cmp(str)==0){
			ret = i;
			break;
		}
	}
	return ret;
}

PUBLIC int SSTRINGS::lookup(const SSTRING *str) const
{
	return lookup (str->get());
}


/*
	Remove empty line in a string table
*/
PUBLIC void SSTRINGS::remove_empty ()
{
	for (int i=0; i<getnb(); i++){
		SSTRING *s = getitem(i);
		if (s->is_empty()){
			remove_del(s);
			i--;
		}
	}
}

/*
	Remove duplicate strings
	Assume the array is already sorted.
*/
PUBLIC void SSTRINGS::remove_dups ()
{
	if (getnb() > 0){
		const char *last = getitem(0)->get();
		for (int i=1; i<getnb(); i++){
			SSTRING *s = getitem(i);
			if (s->cmp(last)==0){
				remove_del(s);
				i--;
			}else{
				last = s->get();
			}
		}
	}
}

PUBLIC void SSTRINGS::append (const SSTRINGS &tb)
{
	int nbtb = tb.getnb();
	for (int i=0; i<nbtb; i++){
		add (new SSTRING (tb.getitem(i)->get()));
	}
}
		

