#include "diadef.h"
#include "dialog.h"

/*
 * Display a dialog box with a list of options that can be turned on or off
 */
int dialog_checklist_p(
	const char *title,
	const char *prompt,
	HELP_FILE &helpfile,
	int list_height,
	int item_no,
	char **items)

{
	int ret = -1;
	/* Allocate space for storing item on/off status */
	char *status = (char*)malloc(item_no);
	char **tmp_items = (char**)malloc(item_no*2*sizeof(char*));
	if (status == NULL || tmp_items == NULL) {
		endwin();
		fprintf(stderr, "\nCan't allocate memory in dialog_checklist().\n");
		exit(-1);
	}else{
		/* Initializes status */
		int i;
		for (i = 0; i < item_no; i++){
			status[i] = !strcasecmp(items[i*3 + 2], "on");
			tmp_items[i*2] = items[i*3];
			tmp_items[i*2+1] = items[i*3+1];
		}
		ret = dialog_checklist (title,prompt,helpfile,list_height,item_no,items,status);
		if (ret == 0){
			for (i = 0; i < item_no; i++){
				if (status[i]) fprintf(stderr, "\"%s\" ", items[i*3]);
			}
		}
		free (status);
		free (tmp_items);
	}
	return ret;
}

