#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/time.h>
#include "askrunlevel.h"
#include <misc.h>
#include "../paths.h"
#include "askrunlevel.m"
#include <dialog.h>

static HELP_FILE help_boot_log (HELP_ASKRUN,"bootlog");

static CONFIG_FILE f_boot_log (VAR_LOG_BOOT_LOG
	,help_boot_log
	,CONFIGF_OPTIONNAL|CONFIGF_MANAGED);

static const char bootlog_key[]="#########";
/*
	Store the boot message in /var/adm/boot.log
*/
void boot_save2log()
{
	/* #Specification: askrunlevel / boot log
		At each boot, askrunlevel grab the log (/proc/kmsg) and
		stores it in /var/adm/boot.log. askrunlevel can present
		these logs to the user later.

		For this reason, you won't find this information in
		/var/adm/messages like a normal linux.
	*/
	FILE *fout = f_boot_log.fopen ("a");
	if (fout != NULL){
		{
			time_t tim = time(NULL);
			const char *datestr = asctime(localtime(&tim));
			fprintf (fout,"%s %s\n",bootlog_key,datestr);
		}
		int fin = open ("/proc/kmsg",O_RDONLY|O_NDELAY);
		if (fin != -1){
			fd_set set;
			FD_ZERO (&set);
			FD_SET (fin,&set);
			struct timeval timeout;
			timeout.tv_usec = timeout.tv_sec = 0;
			if (select(fin+1,&set,NULL,NULL,&timeout)>0){
				char buf[5000];
				int nb = read (fin,buf,sizeof(buf)-1);
				if (nb >= 0){
					buf[nb] = '\0';
					if (fout != NULL){
						fputs (buf,fout);
					}
				}
			}
			close (fin);
		}
		fclose (fout);
	}	
}

/*
	Locate all boot intro or a specific log in the log file

	if choice == -1, get all intro
	if choice != -1. get one log
*/
static int boot_getlist(
	CONFIG_FILE &fcfg,
	const char *dateprefixs[],
	SSTRINGS &lst,
	int choice)
{
	FILE *fin = fcfg.fopen ("r");
	if (fin != NULL){
		char buf[300];
		int collect = 0;
		int nbboot = 0;
		int sizekeys[20];
		for (int k=0; dateprefixs[k] != NULL; k++){
			sizekeys[k] = strlen(dateprefixs[k]);
		}
		while (fgets(buf,sizeof(buf)-1,fin)!=NULL){
			strip_end (buf);
			int prefix = 0;
			int sizekey = 0;
			for (int i=0; dateprefixs[i] != NULL; i++){
				if (strncmp(buf,dateprefixs[i],sizekeys[i])==0){
					prefix = 1;
					sizekey = sizekeys[i];
					break;
				}
			}
			if (prefix){
				if (choice == -1){
					lst.add (new SSTRING (buf+sizekey+1));
				}else if (choice == nbboot){
					collect = 1;
				}else{
					collect = 0;
				}
				nbboot++;
			}else if (collect){
				lst.add (new SSTRING (buf));
			}
		}
		fclose (fin);
	}
	return lst.getnb();
}


/*
	Present the logs of the last boots
*/
void boot_showlog (
	CONFIG_FILE &fcfg,			// Log file to read
	const char *dateprefixs[],	// Prefix to identify session lines
	const char *title,
	const char *intro,
	HELP_FILE &help)
{
	SSTRINGS lst;
	int nb = boot_getlist(fcfg,dateprefixs,lst,-1);
	if (nb == 0){
		xconf_error (MSG_U(E_NOLOG,"No log available"));
	}else{
		int choice = nb - 1;
		DIALOG dia;
		for (int i=0; i<lst.getnb(); i++){
			SSTRING *st = lst.getitem(i);
			dia.new_menuitem("",st->get());
		}
		while (1){
			MENU_STATUS code = dia.editmenu (title,intro,help,choice,0);
			if (code == MENU_OK){
				SSTRINGS onelog;
				if (boot_getlist(fcfg,dateprefixs,onelog,choice)==0){
					xconf_error (MSG_U(E_EMPTYLOG,"Empty log"));
				}else{
					dialog_textbox (lst.getitem(choice)->get(),onelog);
				}
			}else{
				break;
			}
		}
	}
}

/*
	Present the logs of the last boots
*/
void boot_showlog ()
{
	const char *tb[]={bootlog_key,NULL};
	boot_showlog (f_boot_log,tb
		,MSG_U(T_BOOTLOG,"boot log")
		,MSG_U(I_BOOTLOG
			 ,"These are the recording of the previous\n"
			  "boot of this machine")
		,help_boot_log);
}


