#!/usr/bin/perl -w

use IO::Handle;

# Initialize
$new = 0;
$old = 0;
$ok  = 0;

# Load current translation versions
open CURRENT, "<.translation_of"
	or die "Unable to open '.translation_of': $!\n";

while (<CURRENT>)
{
	if (/^(\S+)\s+([0-9].*)$/)
	{
		$current{$1} = $2;
	}
}

# Load CVS version numbers
open CVS, "<../C/CVS/Entries"
	or die "Unable to open '../C/CVS/Entries': $!\n";

while (<CVS>)
{
	if (m"^/([^/]*)/([0-9][^/]*)/")
	{
		$cvs{$1} = $2;
		unless (defined $current{$1})
		{
			print "New file: $1\n";
			$new ++;
		}
	}
}

# Get diffs
chdir "../C" or die "Unable to change to ../C directory: $!\n";

foreach (sort keys %current)
{
	if ($current{$_} ne $cvs{$_})
	{
		print "Need to update $_ from $current{$_} to $cvs{$_}\n";
		print "=" x 75, "\n";
		STDOUT->flush;
		system("cvs -z3 diff -u -r '$current{$_}' -r '$cvs{$_}' '$_'");
		STDOUT->flush;
		print "\n";
		$old ++;
	}
	else
	{
		$ok ++;
	}
}

# Print results
print "Statistics:\n";
print " New files:      $new\n";
print " Needing update: $old\n";
print " Translation ok: $ok\n";
