/*
 * (C) Copyright Keith Visco 1999  All rights reserved.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by
 * you as a result of using the Program. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or
 * lost profits even if the Copyright owner has been advised of the
 * possibility of their occurrence.
 */

package xslp.xml.parsers;

import org.w3c.dom.*;
import oracle.xml.parser.XMLParser;
import org.xml.sax.*;

import java.io.Reader;
import java.io.PrintWriter;
/**
 * Creates a DOM Parser for use with Oracles XML package
 * @author Keith Visco (kvisco@ziplink.net)
**/
public class OracleParser 
    implements com.kvisco.xml.parser.DOMPackage
{
    
    private boolean validate = false;
    
      //----------------/    
     //- Constructors -/
    //----------------/    
    
    public OracleParser() {
        super();
    }
    
      //---------------------------------------------------/    
     //- Interfaces for com.kvisco.xml.parser.DOMPackage -/
    //---------------------------------------------------/    
    
    /**
     * Creates a DOM Document 
     * @return the new Document
    **/
    public Document createDocument() {
        return new oracle.xml.parser.XMLDocument();
    } //-- createDocument
    
    /**
     * Creates a DOM DocumentType using the DOM package of this DOMReader
     * @return the new DocumentType
    **/
    public void setDocumentType(Document document, String systemId) {
    } //-- setDocumentType
    
    /**
     * Sets whether or not to Validate the Document
     * @param validate a boolean indicating whether or not to
     * validate the Document
    **/
    public void setValidation(boolean validate) {
        this.validate = validate;
    } //-- setValidation

    /**
     * Reads an XML Document from the given Reader
     * @param reader the Reader for reading the XML stream
     * @param filename
     * @param errorWriter the PrintWriter to write all errors to
    **/
    public Document readDocument(Reader reader, String filename, PrintWriter errorWriter) {
        
		
		Document doc = null;
		try {
	        XMLParser xmlParser = new XMLParser();
	        
	        xmlParser.setValidationMode(validate);
	        
	        // handle entities?
    		xmlParser.parse(new InputSource(reader));
    		doc = xmlParser.getDocument();
		}
		catch (Exception ex) {
		    errorWriter.println("error while trying to read document.");
		    errorWriter.println(" - " + ex.getMessage());
		    errorWriter.flush();
		}
		
		
        return doc;
		
	} //-- readDocument
    
} //-- DOMParser

